unit intrfs;

INTERFACE

uses dos,graph;

type
  TRect=object
    x1,y1,x2,y2:integer;
    function Inside:boolean;
    procedure HideNearMouse;
    procedure Fill(colo:byte);
  end;
  language=(ru,en);      {}
  stri=array [language] of string[25];
  TText=object(TRect)
    s  : stri;    {}
    procedure Write;
  end;
  TKnop=object(TText)              {  ࠭  ࠢ 誮}
    p           : boolean;      {稥 䨪  ᪠- }
    k           : byte;         {᪠- ᮮ⢥饩 }
    procedure Passiv;
    procedure Aktiv(colo:byte);
  end;
  TImage=object(TRect)
    xc,yc : byte;
    ima   : array [0..31] of word;
    procedure GraphCursor;
  end;
  TRegulator=object(TRect)
    txt     : TText;
    pol     : TRect;
    am,ap,a : longint;
    x,fixx  : integer;
    ai      : longint;
    procedure Create(xx1,yy1,l:integer;aam,aap,aa:longint;st:stri);
    procedure Show;
    procedure Hide;
    procedure PolShow(aa:longint);
    procedure PolHide;
    procedure Move;
    procedure Drag;
  end;
  TList=object(TRect)
    am,ap,ac,app  : longint;
    wnd           : TRect;
    cu            : TRect;
    scb           : array [1..5] of TKnop;
    dy          : integer;
    constructor Create(xx,yy:integer;n,aam,aac:longint);
    procedure Visible;virtual;
    procedure VisScBar;
    procedure WriteStr(i:longint);
    function Stro(i:longint):string;virtual;
    procedure MoveCur(i:longint);virtual;
    procedure Move(i:longint);virtual;
    procedure MoveScBar;
    procedure OnKey;
    procedure OnClick;
    procedure OnMousePress;
  end;
  TEdit=object(TText)
    procedure Create(xx,yy:integer);
    procedure Visible;
    procedure OnKey;
  end;
  TProgressBar=object(TRect)
    x01,x02,y0,x : integer;
    procedure Create(xx,yy:integer);
    procedure Visible;
    procedure ClearPr;
    procedure ShowPr(xx:integer);
  end;
const
  lan     : language   = ru;      {}
  pre0    : boolean    = false;   {䨪 0   }
var
  ke       : byte;   {᪠- }
  reg      : registers;
  xm,ym    : integer;{न }
  mbtns    : integer;{ﭨ  }
  mxep     : boolean;
function IsMouse:boolean;
procedure ShowMouse;
procedure HideMouse;
procedure InitMouse;
procedure MouseHandler;far;
procedure SetMouseHandler(mask:word);
procedure ClearMouseHandler;
procedure ClearKeyboardHandler;

IMPLEMENTATION

const
  ChrStr  : string[50] =' 1234567890-   QWERTYUIOP{}'
     +'  ASDFGHJKL ''~  ZXCVBNM'; {஢ }
  MouPr   : boolean    = false;   {稥 }
  MouVis  : boolean    = false;   { }
  NButton : byte       = 0;       {᫮  }
var
  grDriver,grMode   : integer;
  OldKeyboardVector : pointer;{ 뢠  }
  pFlag             : ^byte;  {  ﭨ }

  {$B-}

function TRect.Inside;
begin
  Inside:=(xm>=x1)and(xm<=x2)and(ym>=y1)and(ym<=y2)
end;

procedure TRect.Fill;
begin
  SetFillStyle(1,colo);
  bar(x1,y1,x2,y2)
end;

procedure TRect.HideNearMouse;
begin
  if (xm+16>=x1)and(xm-16<=x2)and(ym+16>=y1)and(ym-16<=y2) then HideMouse
end;

procedure TText.Write;
begin
  OutTextXY((x1+x2) shr 1+5,(y1+y2) shr 1-2,s[lan])
end;

procedure TKnop.Passiv;
begin
  SetColor(7);
  SetLineStyle(0,0,1);
  line(x1,y2-2,x1,y1);
  line(x1,y1,x2-2,y1);
  line(x2-1,y1,x2-1,y2-1);
  line(x2-1,y2-1,x1,y2-1);
  line(x1+1,y2,x2,y2);
  line(x2,y2,x2,y1+1)
end;

procedure TKnop.Aktiv;
begin
  SetColor(15);
  SetLineStyle(0,0,1);
  line(x1,y2-2,x1,y1);
  line(x1,y1,x2-2,y1);
  SetColor(colo);
  line(x2-1,y1,x2-1,y2-1);
  line(x2-1,y2-1,x1,y2-1);
  line(x1+1,y2,x2,y2);
  line(x2,y2,x2,y1+1)
end;

function IsMouse:boolean;
var
  p     : pointer;
  k,x,y : integer;
  is    : boolean;
begin
  if NButton=0 then
    begin
      GetIntVec($33,p);
      is:=p<>nil;
      if is then with reg do
        begin
          ax:=$3;
          bx:=$ffff;
          Intr($33,reg);
          is:=bx<>$ffff
        end;
      MouPr:=is
    end;
  IsMouse:=MouPr
end;

procedure ShowMouse;
begin
  if IsMouse and not MouVis then
    with reg do
      begin
        ax:=$1;
        Intr($33,reg);
        MouVis:=true
      end
end;

procedure HideMouse;
begin
  if IsMouse and MouVis then
    with reg do
      begin
        ax:=$2;
        Intr($33,reg);
        MouVis:=false
      end
end;

procedure InitMouse;
begin
  with reg do
    begin
      ax:=0;
      Intr($33,reg);
      MouPr:=ax=$ffff;
      NButton:=bx
    end;
  HideMouse
end;

procedure MouseHandler;assembler;
asm
  push bp
  push ds
  push es
  mov  ax,SEG @DATA
  mov  ds,ax
  mov  mbtns,bx
  mov  xm,cx
  mov  ym,dx
  mov  mxep,true
  pop es
  pop  ds
  pop  bp
  ret  far
end;

procedure SetMouseHandler(mask:word);
begin
  if IsMouse then with reg do
    begin
      ax:=$0c;
      cx:=mask;
      es:=seg(MouseHandler);
      dx:=ofs(MouseHandler);
      Intr($33,reg)
    end
end;

procedure ClearMouseHandler;
begin
  if IsMouse then with reg do
    begin
      ax:=$0c;
      cx:=0;
      es:=0;
      dx:=0;
      Intr($33,reg)
    end
end;

procedure TImage.GraphCursor;
begin
  if IsMouse then with reg do
    begin
      ax:=$9;
      bx:=xc;cx:=yc;
      es:=seg(ima);
      dx:=ofs(ima);
      Intr($33,reg)
    end
end;

procedure TRegulator.Create(xx1,yy1,l:integer;aam,aap,aa:longint;st:stri);
begin
x1:=xx1;y1:=yy1;x2:=xx1+l;y2:=yy1+30;
with txt do
  begin
    x1:=xx1;y1:=yy1;x2:=xx1+l;y2:=yy1+12;
    s:=st
  end;
with pol do begin y1:=yy1+12;y2:=yy1+28 end;
am:=aam;ap:=aap;
a:=aa;
ai:=0
end;

procedure TRegulator.Show;
begin
txt.Fill(7);
SetColor(6);
txt.Write;
SetLineStyle(0,0,3);
line(x1+5,y2-10,x2-5,y2-10);
PolShow(a)
end;

procedure TRegulator.Hide;
begin
  Fill(7)
end;

procedure TRegulator.PolShow(aa:longint);
begin
  a:=aa;x:=x1+(x2-x1-20)*(a-am) div (ap-am)+10;
  with pol do
    begin
      x1:=x-3;x2:=x+3;
      SetLineStyle(0,0,3);
      SetColor(7);
      line(x1,y1+8,x2,y1+8);
      SetLineStyle(0,0,1);
      SetColor(6);
      rectangle(x1,y1,x2,y2)
    end
end;

procedure TRegulator.PolHide;
begin
  pol.Fill(7);
  SetLineStyle(0,0,3);
  SetColor(6);
  with pol do line(x1,y1+8,x2,y1+8)
end;

procedure TRegulator.Move;
begin
    HideNearMouse;
    PolHide;
    a:=a+ai;
    PolShow(a);
    ShowMouse;
    if fixx<>0 then fixx:=fixx+ai*(x2-x1-20) div (ap-am)
end;

procedure TRegulator.Drag;
begin
    if fixx<>0 then
      begin ai:=(xm-fixx)*(ap-am) div (x2-x1-20);
            if a+ai>ap then ai:=ap-a else
              if a+ai<am then ai:=am-a
      end
    else ai:=0
end;

constructor TList.Create;
var cc : longint;
begin
  x1:=xx;y1:=yy;x2:=xx+150;y2:=yy+n*15;
  am:=aam;ap:=aam+n-1;ac:=aac;dy:=-1;
  with wnd do
    begin x1:=xx;y1:=yy;x2:=xx+139;y2:=yy+n*15-1 end;
  with cu do
    begin x1:=xx;x2:=xx+139 end;
  for cc:=1 to 5 do with scb[cc] do
    begin x1:=xx+140;x2:=x1+10;s[ru]:='';s[en]:='';p:=false end;
  with scb[1] do begin y1:=yy;y2:=yy+10;k:=$68 end;
  with scb[2] do begin y1:=scb[1].y2;y2:=y1;k:=$49 end;
  scb[5].y2:=y2;
  with scb[5] do begin y1:=y2-10;k:=$70 end;
  with scb[4] do begin y2:=scb[5].y1-1;y1:=y2;k:=$51 end;
  with scb[3] do begin y1:=scb[2].y2;y2:=scb[4].y1 end;
end;

procedure TList.Visible;
var ii : longint;
begin
  wnd.Fill(15);
  Stro(0);
  if ap>app then begin am:=app-ap+am;if am<1 then am:=1;ap:=app end;
  if ac>app then ac:=app;
  if am<1 then begin ap:=ap-am+1;am:=1 end;
  if ac<1 then ac:=1;
  cu.y1:=y1+(ac-am)*15;cu.y2:=cu.y1+14;
  cu.Fill(9);
  for ii:=am to ap do WriteStr(ii)
end;

procedure TList.VisScBar;
var i : integer;
begin
with scb[3] do begin y1:=scb[1].y2+1+(am-1)*(scb[5].y1-scb[1].y2-1) div app;
                     y2:=y1+(ap-am+1)*(scb[5].y1-scb[1].y2-1) div app;
                     scb[2].y2:=y1-1;scb[4].y1:=y2+1
               end;
SetFillStyle(1,7);
bar(scb[1].x1,y1,scb[5].x2,y2);
for i:=0 to 2 do with scb[2*i+1] do Aktiv(6);
with scb[1] do begin
                 line(x1+2,y1+7,x2-3,y1+7);
                 line(x2-3,y1+7,x1+5,y1+3);
                 line(x1+5,y1+3,x1+2,y1+7)
               end;
with scb[5] do begin
                 line(x1+2,y2-7,x2-3,y2-7);
                 line(x2-3,y2-7,x1+5,y2-3);
                 line(x1+5,y2-3,x1+2,y2-7)
               end;
with scb[2] do begin line(x1,y1,x1,y2);line(x2,y1,x2,y2) end;
with scb[4] do begin line(x1,y1,x1,y2);line(x2,y1,x2,y2) end
end;

procedure TList.MoveScBar;
var i : integer;
begin
with scb[3] do begin
                 Fill(7);
                 SetColor(6);
                 line(x1,y1,x1,y2);line(x2,y1,x2,y2);
                 y1:=scb[1].y2+1+(am-1)*(scb[5].y1-scb[1].y2-1) div app;
                 y2:=y1+(ap-am+1)*(scb[5].y1-scb[1].y2-1) div app;
                 scb[2].y2:=y1-1;scb[4].y1:=y2+1;
                 Aktiv(6)
               end
end;


procedure TList.WriteStr;
var st:TText;
begin
  st.x1:=x1;st.y1:=(i-am)*15+y1;
  SetColor(0);
  with st do
    begin x2:=x1+140;y2:=y1+14;s[lan]:=Stro(i);Write end
end;

function TList.Stro;
begin end;

procedure TList.MoveCur;
begin
  ac:=ac+i;
  if ac<1 then ac:=1;
  if ac>app then ac:=app;
  HideNearMouse;
  if (ac<am) or (ac>ap) then
    begin ap:=ap+i;am:=am+i;
          Visible;MoveScBar
    end
  else
    begin
      cu.Fill(15);WriteStr(am+(cu.y1-y1) div 15);
      cu.y1:=y1+(ac-am)*15;cu.y2:=cu.y1+14;
      cu.Fill(9);WriteStr(ac)
    end;
  ShowMouse
end;

procedure TList.Move;
begin
  if (am+i>0) and (ap+i<=app) then
  begin
    ac:=ac+i;
    ap:=ap+i;am:=am+i;
    HideNearMouse;
    Visible;MoveScBar;
    ShowMouse
  end
  else MoveCur(i)
end;

procedure TList.OnKey;
begin
  case ke of
    $48  {up}    : MoveCur(-1);
    $50  {down}  : MoveCur(1);
    $49  {pgup}  : MoveCur(-ap+am-1);
    $51  {pgdn}  : MoveCur(ap-am+1);
    $47  {home}  : MoveCur(-ac);
    $4f  {end}   : MoveCur(app-ac);
    $68  {mouup} : Move(-1);
    $70  {moudn} : Move(1);
  end;
  if ke<>1 then ke:=0
end;

procedure TList.OnClick;
begin
  if wnd.InSide then MoveCur((ym-y1) div 15+am-ac);
  with scb[3] do if Inside then dy:=ym-y1;
  OnMousePress
end;

procedure TList.OnMousePress;
var ii : longint;
begin
  if (dy>=0) then if (xm>scb[1].x1-5) and (xm<x2) then
    begin
      ii:=(ym-scb[3].y1-dy)*app div (scb[5].y1-scb[1].y2-1);
      if ap+ii>app then ii:=app-ap else
        if am+ii<1 then ii:=1-am;
      if ii<>0 then Move(ii)
    end else
  else for ii:=1 to 5 do
    with scb[ii] do if InSide then begin ke:=k;OnKey end
end;

procedure TEdit.Create;
begin
  x1:=xx;y1:=yy;x2:=xx+150;y2:=yy+20;
  s[ru]:='';s[en]:=''
end;

procedure TEdit.Visible;
begin
  Fill(15);
  s[ru]:=s[en];
  Write
end;

procedure TEdit.OnKey;
begin
  case ke of
    $0e  {bksp}  : delete(s[en],length(s[en]),1);
    $1c  {enter} : ke:=$01;
    $01  {esc}   : s[en]:='';
    $53  {del}   : s[en]:='';
  else
     if (length(s[en])<8) and (ke in [$02..$32]) and (ChrStr[ke]<>' ')
        then s[en]:=s[en]+ChrStr[ke];
  end;
  if s[ru]<>s[en] then Visible
end;

procedure TProgressBar.Create;
begin
  x1:=xx;y1:=yy;x2:=xx+140;y2:=yy+10;
  x01:=x1+6;x02:=x2-6;y0:=y1+5;x:=0
end;

procedure TProgressBar.Visible;
begin
  SetColor(1);
  SetLineStyle(0,0,3);
  Rectangle(x1+1,y1+1,x2-1,y2-1)
end;

procedure TProgressBar.ClearPr;
begin
  SetColor(7);
  SetLineStyle(0,0,3);
  HideNearMouse;
  line(x01,y0,x02,y0);
  ShowMouse;
  x:=0
end;

procedure TProgressBar.ShowPr;
begin
if xx>x then begin
  SetColor(4);
  SetLineStyle(0,0,3);
  HideNearMouse;
  line(x01+x,y0,x01+xx,y0);
  ShowMouse;
  x:=xx
end
end;

procedure KeyboardHandler;interrupt;
begin
 ke:=port[$60];
 if ke and $80 <> 0 then begin pre0:=ke=$e0;ke:=0 end;
 port[$20]:=$20
end;

procedure SetKeyboardHandler;
begin
  GetIntVec(9,OldKeyboardVector);
  SetIntVec(9,@KeyboardHandler);
  pFlag:=Ptr(0,$417);
  pFlag^:=pFlag^ and $f0
end;

procedure ClearKeyboardHandler;
begin
  SetIntVec(9,OldKeyboardVector)
end;

BEGIN
  SetKeyboardHandler;
  grDriver := Detect;
  InitGraph( grDriver, grMode, '' );
END.