#include "bmpimage.h"
void MakeUp2(unsigned char *Dim,unsigned char *ScLine,long Width,long ScanLine)
{ long i;
  for(i=0;i<ScanLine;i++) ScLine[i]=0;
  for(i=0;i<Width;i++)
   ScLine[i/8]+=(Dim[i]?1:0)<<(7-i%8)%8;
}

void fputbmpimage2(long x1,long y1,long x2,long y2,char *FileName)
{ BITMAPFILE bm;
  unsigned char i,r,g,b;
  unsigned char *Dim,*ScLine;
  long ScanLine,MaxColor,BitPerColor,Width,Height,x,y;
  Width=x2-x1+1;
  Height=y2-y1+1;
  MaxColor=2;
  BitPerColor=1;
  ScanLine=(x2-x1+1)*BitPerColor/8;
  if((x2-x1+1)*BitPerColor%8) ScanLine++;
  ScanLine+=(4-ScanLine%4)%4;
  bm.bmFile=fopen(FileName,"wb");

  bm.bmFileHeader.bfType=0x4D42;
  bm.bmFileHeader.bfSize=sizeof(BITMAPFILEHEADER)+
						 sizeof(BITMAPINFOHEADER)+
						 sizeof(RGBQUAD)*MaxColor+
						 Height*ScanLine;
  bm.bmFileHeader.bfReserved1=0;
  bm.bmFileHeader.bfReserved2=0;
  bm.bmFileHeader.bfOffbits=sizeof(BITMAPFILEHEADER)+
							sizeof(BITMAPINFOHEADER)+
							sizeof(RGBQUAD)*MaxColor;

  bm.bmInfo.bmiHeader.biSize=sizeof(BITMAPINFOHEADER);
  bm.bmInfo.bmiHeader.biWidth=Width;
  bm.bmInfo.bmiHeader.biHeight=Height;
  bm.bmInfo.bmiHeader.biPlanes=1;
  bm.bmInfo.bmiHeader.biBitCount=BitPerColor;
  bm.bmInfo.bmiHeader.biCompression=0;
  bm.bmInfo.bmiHeader.biSizeImage=Height*ScanLine;
  bm.bmInfo.bmiHeader.biXPelsPerMeter=0x00000EC4;
  bm.bmInfo.bmiHeader.biYPelsPerMeter=0x00000EC4;
  bm.bmInfo.bmiHeader.biClrUsed=0;
  bm.bmInfo.bmiHeader.biClrImportant=0;

  bm.bmInfo.bmiColors=new RGBQUAD [MaxColor];
  getrgb(0,r,g,b);
  bm.bmInfo.bmiColors[0].rgbRed=r;
  bm.bmInfo.bmiColors[0].rgbGreen=g;
  bm.bmInfo.bmiColors[0].rgbBlue=b;
  bm.bmInfo.bmiColors[0].rgbReserved=0;
  getrgb(getmaxcolor(),r,g,b);
  bm.bmInfo.bmiColors[1].rgbRed=r;
  bm.bmInfo.bmiColors[1].rgbGreen=g;
  bm.bmInfo.bmiColors[1].rgbBlue=b;
  bm.bmInfo.bmiColors[1].rgbReserved=0;


  fwrite(&bm.bmFileHeader,sizeof(BITMAPFILEHEADER),1,bm.bmFile);
  fwrite(&bm.bmInfo.bmiHeader,sizeof(BITMAPINFOHEADER),1,bm.bmFile);
  fwrite(bm.bmInfo.bmiColors,sizeof(RGBQUAD)*MaxColor,1,bm.bmFile);

  Dim=new unsigned char [Width];
  ScLine=new unsigned char [ScanLine];
  for(y=y2;y>=y1;y--)
  { for(x=x1;x<=x2;x++)
	 Dim[x-x1]=getpixel(x,y);
	MakeUp2(Dim,ScLine,Width,ScanLine);
	fwrite(ScLine,ScanLine,1,bm.bmFile);
  }
  delete[] Dim,ScLine,bm.bmInfo.bmiColors;
  fclose(bm.bmFile);
}

void MakeDown2(unsigned char *Dim,unsigned char *ScLine,long Width)
{ long i;
  for(i=0;i<Width;i++)
   Dim[i]=(ScLine[i/8]&(0x01<<(7-i%8)%8))?getmaxcolor():0;
}

void fgetbmpimage2(long x,long y,char *FileName)
{ BITMAPFILE bm;
  long ScanLine,Width,X,Y,i;
  unsigned char *Dim,*ScLine;
  bm.bmFile=fopen(FileName,"rb");
  bm.bmInfo.bmiColors=new RGBQUAD [2];
  fread(&bm.bmFileHeader,sizeof(BITMAPFILEHEADER),1,bm.bmFile);
  fread(&bm.bmInfo.bmiHeader,sizeof(BITMAPINFOHEADER),1,bm.bmFile);
  fread(bm.bmInfo.bmiColors,sizeof(RGBQUAD)*2,1,bm.bmFile);
  setrgb(0,bm.bmInfo.bmiColors[0].rgbRed,
			bm.bmInfo.bmiColors[0].rgbGreen,
			bm.bmInfo.bmiColors[0].rgbBlue);
  setrgb(getmaxcolor(),bm.bmInfo.bmiColors[1].rgbRed,
			bm.bmInfo.bmiColors[1].rgbGreen,
			bm.bmInfo.bmiColors[1].rgbBlue);
  Width=bm.bmInfo.bmiHeader.biWidth;
  ScanLine=Width*bm.bmInfo.bmiHeader.biBitCount/8;
  if(Width*bm.bmInfo.bmiHeader.biBitCount%8)ScanLine++;
  while(ScanLine%4) ScanLine++;
  ScLine=new unsigned char [ScanLine];
  Dim=new unsigned char [Width];
  for(Y=y+bm.bmInfo.bmiHeader.biHeight-1;Y>=y;Y--)
  { fread(ScLine,ScanLine,1,bm.bmFile);
	MakeDown2(Dim,ScLine,Width);
	for(X=x;X<=x+Width-1;X++)
	 putpixel(X,Y,Dim[X-x]);
  }
  delete[] bm.bmInfo.bmiColors,Dim,ScLine;
  fclose(bm.bmFile);
}



void MakeUp16(unsigned char *Dim,unsigned char *ScLine,long Width,long ScanLine)
{ long i;
  for(i=0;i<ScanLine;i++) ScLine[i]=0;
  for(i=0;i<Width;i++)
   if(i%2)
	 ScLine[i/2]+=Dim[i];
   else
	 ScLine[i/2]+=Dim[i]<<4;
}

void fputbmpimage16(long x1,long y1,long x2,long y2,char *FileName)
{ BITMAPFILE bm;
  unsigned char i,r,g,b;
  unsigned char *Dim,*ScLine;
  long ScanLine,MaxColor,BitPerColor,Width,Height,x,y;
  Width=x2-x1+1;
  Height=y2-y1+1;
  MaxColor=16;
  BitPerColor=4;
  ScanLine=(x2-x1+1)*BitPerColor/8;
  if((x2-x1+1)*BitPerColor%8) ScanLine++;
  ScanLine+=(4-ScanLine%4)%4;
  bm.bmFile=fopen(FileName,"wb");

  bm.bmFileHeader.bfType=0x4D42;
  bm.bmFileHeader.bfSize=sizeof(BITMAPFILEHEADER)+
						 sizeof(BITMAPINFOHEADER)+
						 sizeof(RGBQUAD)*MaxColor+
						 Height*ScanLine;
  bm.bmFileHeader.bfReserved1=0;
  bm.bmFileHeader.bfReserved2=0;
  bm.bmFileHeader.bfOffbits=sizeof(BITMAPFILEHEADER)+
							sizeof(BITMAPINFOHEADER)+
							sizeof(RGBQUAD)*MaxColor;

  bm.bmInfo.bmiHeader.biSize=sizeof(BITMAPINFOHEADER);
  bm.bmInfo.bmiHeader.biWidth=Width;
  bm.bmInfo.bmiHeader.biHeight=Height;
  bm.bmInfo.bmiHeader.biPlanes=1;
  bm.bmInfo.bmiHeader.biBitCount=BitPerColor;
  bm.bmInfo.bmiHeader.biCompression=0;
  bm.bmInfo.bmiHeader.biSizeImage=Height*ScanLine;
  bm.bmInfo.bmiHeader.biXPelsPerMeter=0x00000EC4;
  bm.bmInfo.bmiHeader.biYPelsPerMeter=0x00000EC4;
  bm.bmInfo.bmiHeader.biClrUsed=0;
  bm.bmInfo.bmiHeader.biClrImportant=0;

  bm.bmInfo.bmiColors=new RGBQUAD [MaxColor];
  for(i=0;i<MaxColor;i++)
  { getrgb(i,r,g,b);
	bm.bmInfo.bmiColors[i].rgbRed=r;
	bm.bmInfo.bmiColors[i].rgbGreen=g;
	bm.bmInfo.bmiColors[i].rgbBlue=b;
	bm.bmInfo.bmiColors[i].rgbReserved=0;
  }

  fwrite(&bm.bmFileHeader,sizeof(BITMAPFILEHEADER),1,bm.bmFile);
  fwrite(&bm.bmInfo.bmiHeader,sizeof(BITMAPINFOHEADER),1,bm.bmFile);
  fwrite(bm.bmInfo.bmiColors,sizeof(RGBQUAD)*MaxColor,1,bm.bmFile);

  Dim=new unsigned char [Width];
  ScLine=new unsigned char [ScanLine];
  for(y=y2;y>=y1;y--)
  { for(x=x1;x<=x2;x++)
	 Dim[x-x1]=getpixel(x,y);
	MakeUp16(Dim,ScLine,Width,ScanLine);
	fwrite(ScLine,ScanLine,1,bm.bmFile);
  }
  delete[] Dim,ScLine,bm.bmInfo.bmiColors;
  fclose(bm.bmFile);
}


void MakeDown16(unsigned char *Dim,unsigned char *ScLine,long Width)
{ long i;
  for(i=0;i<Width;i++)
   if(i%2)
	Dim[i]=ScLine[i/2]&0x0F;
   else
	Dim[i]=ScLine[i/2]>>4;
}

void fgetbmpimage16(long x,long y,char *FileName)
{ BITMAPFILE bm;
  long ScanLine,Width,X,Y,i;
  unsigned char *Dim,*ScLine;
  bm.bmFile=fopen(FileName,"rb");
  bm.bmInfo.bmiColors=new RGBQUAD [16];
  fread(&bm.bmFileHeader,sizeof(BITMAPFILEHEADER),1,bm.bmFile);
  fread(&bm.bmInfo.bmiHeader,sizeof(BITMAPINFOHEADER),1,bm.bmFile);
  fread(bm.bmInfo.bmiColors,sizeof(RGBQUAD)*16,1,bm.bmFile);
  for(i=0;i<16;i++)
   setrgb(i,bm.bmInfo.bmiColors[i].rgbRed,
			bm.bmInfo.bmiColors[i].rgbGreen,
			bm.bmInfo.bmiColors[i].rgbBlue);
  Width=bm.bmInfo.bmiHeader.biWidth;
  ScanLine=Width*bm.bmInfo.bmiHeader.biBitCount/8;
  if(Width*bm.bmInfo.bmiHeader.biBitCount%8)ScanLine++;
  while(ScanLine%4) ScanLine++;
  ScLine=new unsigned char [ScanLine];
  Dim=new unsigned char [Width];
  for(Y=y+bm.bmInfo.bmiHeader.biHeight-1;Y>=y;Y--)
  { fread(ScLine,ScanLine,1,bm.bmFile);
	MakeDown16(Dim,ScLine,Width);
	for(X=x;X<=x+Width-1;X++)
	 putpixel(X,Y,Dim[X-x]);
  }
  delete[] bm.bmInfo.bmiColors,Dim,ScLine;
  fclose(bm.bmFile);
}

