#ifndef __3D__
#define __3D__
#include <stdio.h>
#include <math.h>
#include <graphics.h>

struct options
{ float rho,phi,theta,d;
  float xO,yO,zO;
  int   xC,yC;
  options operator<<(FILE*);
  options operator>>(FILE*);
};

struct object_3d
{ unsigned int  nv;
  unsigned int  *p;
  unsigned int **r;
  float *x;
  float *y;
  float *z;
  object_3d() { nv=0; p=0; r=0; x=0; y=0; z=0; }
  object_3d(object_3d&);
 ~object_3d() { cnv(); }
  object_3d&    addv(float xc,float yc,float zc);
  object_3d&    addr(unsigned int a,unsigned int b);
  object_3d&    delv(unsigned int xc,unsigned int yc,unsigned int zc);
  object_3d&    delv(unsigned int t);
  object_3d&    delr(unsigned int a,unsigned int b);
  unsigned int  getv();
  unsigned long getr();
  long          getn(unsigned int xc,unsigned int yc,unsigned int zc);
  int           isv(unsigned int xc,unsigned int yc,unsigned int zc);
  int           isr(unsigned int a,unsigned int b);
  object_3d&    operator=(object_3d&);
  object_3d&    operator<<(FILE*);
  object_3d&    operator>>(FILE*);
  int	        ver();
  void          cnv();
};

void coeff       (options &op);
void perspective (float x,float y,float z,float &X,float &Y);
void viewing     (float x,float y, float z,float &xe,float &ye,float &ze);
void mv          (float x,float y,float z);
void dw          (float x,float y,float z);
void ln          (float x1,float y1,float z1,float x2,float y2,float z2);
void paint       (object_3d &ob,options &op);

#endif
