#include "3d.h"
/*---------------------------- Variables ------------------------------*/
static float v11,v12,v13,
	     v21,v22,v23,
		 v32,v33,
		     v43,
	     screen_dist,
		   xc,yc;
/*-------------------------- Class options ----------------------------*/
options options::operator>>(FILE *f)
{ fprintf(f,"%+16.6f %+16.6f %+16.6f\n",xO,yO,zO);
  fprintf(f,"%+16.6f %+16.6f %+16.6f %+16.6f\n",rho,theta,phi,d);
  fprintf(f,"%6d %6d\n",xC,yC);
  return(*this);
}

options options::operator<<(FILE *f)
{ fscanf(f,"%f %f %f",&xO,&yO,&zO);
  fscanf(f,"%f %f %f %f",&rho,&theta,&phi,&d);
  fscanf(f,"%d %d",&xC,&yC);
  return(*this);
}
/*------------------------- Class object_3d ---------------------------*/
  object_3d::object_3d(object_3d& g)
{ unsigned int i,j,k;
  nv=g.nv; if (nv==0) { p=0; r=0; return; }
  p=new unsigned int[nv]; r=new unsigned int*[nv];
  x=new float[nv]; y=new float[nv]; z=new float[nv];
  for (i=0;i<nv;i++)
	  { x[i]=g.x[i]; y[i]=g.y[i]; z[i]=g.z[i]; k=p[i]=g.p[i];
		r[i]=new unsigned int[k];
		for (j=0;j<k;j++) r[i][j]=g.r[i][j]; }
}

  object_3d& object_3d::operator=(object_3d& g)
{ cnv(); if (g.nv==0) return *this;
  unsigned int i,j;
  nv=g.nv;
  p=new unsigned int[nv]; r=new unsigned int*[nv];
  x=new float[nv]; y=new float[nv]; z=new float[nv];
  for (i=0;i<nv;i++)
	  { x[i]=g.x[i]; y[i]=g.y[i]; z[i]=g.z[i];
	p[i]=g.p[i]; r[i]=new unsigned int[p[i]];
	for (j=0;j<p[i];j++) r[i][j]=g.r[i][j]; }
  return *this;
}

  object_3d& object_3d::addv(float xc,float yc,float zc)
{ unsigned int *s,**t,i;
  float *a,*b,*c;
  for(i=0;i<nv;i++) if(x[i]==xc&&y[i]==yc&&z[i]==zc) return(*this);
  nv++;
  s=new unsigned int [nv]; t=new unsigned int*[nv];
  a=new float [nv]; b=new float [nv]; c=new float [nv];
  for(i=0;i<nv-1;i++)
	{ s[i]=p[i]; t[i]=r[i];
	  a[i]=x[i]; b[i]=y[i]; c[i]=z[i]; }
  s[nv-1]=0;   t[nv-1]=0;
  a[nv-1]=xc; b[nv-1]=yc; c[nv-1]=zc;
  delete[] p; delete[] r;
  delete[] x; delete[] y; delete[] z;
  x=a; y=b; z=c; p=s; r=t;
  return(*this);
}

  object_3d& object_3d::addr(unsigned int a,unsigned int b)
{ unsigned int *q,z,i,f; f=0;
  for(i=0;i<p[a];i++) if(r[a][i]==b) { f=1; break; }
  if(f==0)
	{ z=p[a]+1; q=new unsigned int [z];
	  for(i=0;i<p[a];i++) q[i]=r[a][i];
	  q[p[a]]=b; delete[] r[a];
	  r[a]=q; p[a]++;
	  z=p[b]+1; q=new unsigned int [z];
	  for(i=0;i<p[b];i++) q[i]=r[b][i];
	  q[p[b]]=a; delete[] r[b];
	  r[b]=q; p[b]++; }
  return(*this);
}
  object_3d& object_3d::delv(unsigned int t)
{ unsigned int **w,*q; unsigned int i,j,k; float *a,*b,*c; long f;
  w=new unsigned int* [nv-1]; q=new unsigned int [nv-1];
  a=new float [nv-1]; b=new float [nv-1]; c=new float [nv-1];
  k=0; delete[] r[t];
  for(i=0;i<t;i++) { w[k]=r[i]; q[k]=p[i]; a[k]=x[i]; b[k]=y[i]; c[k++]=z[i];}
  for(i=t+1;i<nv;i++) { w[k]=r[i]; q[k]=p[i]; a[k]=x[i]; b[k]=y[i]; c[k++]=z[i];}
  delete[] p; delete[] r;
  delete[] x; delete[] y; delete[] z;
  p=q; r=w; x=a; y=b; z=c;
  nv--;
  for(i=0;i<nv;i++)
	{ f=-1;
	  for(j=0;j<p[i];j++)
		{ if(r[i][j]==t) f=j;
		  if(r[i][j]>t) r[i][j]--;
		}
	  if(f>=0)
		{ q=new unsigned int[p[i]-1]; k=0;
		  for(j=0;j<f;j++) q[k++]=r[i][j];
		  for(j=f+1;j<p[i];j++)	q[k++]=r[i][j];
		  delete[] r[i]; r[i]=q; p[i]--;
		}
	}
  return(*this);
}

  object_3d& object_3d::delv(unsigned int xc,unsigned int yc,unsigned int zc)
{ long i=getn(xc,yc,zc);
  if(i>=0) delv(i);
  return(*this);
}

  object_3d& object_3d::delr(unsigned int a,unsigned int b)
{ long f,g; unsigned int i,k,*q; f=-1; g=-1;
  for(i=0;i<p[a];i++) if(r[a][i]==b) f=i;
  for(i=0;i<p[b];i++) if(r[b][i]==a) g=i;
  if(f>=0||g>=0)
	{ q=new unsigned int [p[a]-1]; k=0;
	  for(i=0;i<f;i++) q[k++]=r[a][i];
	  for(i=f+1;i<p[a];i++)	q[k++]=r[a][i];
	  delete[] r[a]; r[a]=q;
	  q=new unsigned int [p[b]-1]; k=0;
	  for(i=0;i<g;i++) q[k++]=r[b][i];
	  for(i=g+1;i<p[b];i++)	q[k++]=r[b][i];
	  delete[] r[b]; r[b]=q; p[a]--; p[b]--;
	}
  return(*this);
}

   unsigned int object_3d::getv()
{ return(nv); }

   unsigned long object_3d::getr()
{ unsigned long s=0; unsigned int i;
  for(i=0;i<nv;i++) s+=p[i];
  return(s/2);
}

  long object_3d::getn(unsigned int xc,unsigned int yc,unsigned int zc)
{ for(long i=0;i<nv;i++) if(x[i]==xc&&y[i]==yc&&z[i]==zc) return(i);
  return(-1);
}

  int object_3d::isv(unsigned int xc,unsigned int yc,unsigned int zc)
{ for(unsigned int i=0;i<nv;i++) if(x[i]==xc&&y[i]==yc&&z[i]==zc) return(1);
  return(0);
}

  int object_3d::isr(unsigned int a,unsigned int b)
{ for(unsigned int i=0;i<p[a];i++) if(r[a][i]==b) return(1);
  return(0);
}

  object_3d& object_3d::operator<<(FILE* f)
{ unsigned int i,j,k,R; float a,b,c; cnv();
  fscanf(f,"%u",&nv);
  p=new unsigned int[nv]; r=new unsigned int*[nv];
  x=new float[nv]; y=new float[nv]; z=new float[nv];
  for (i=0;i<nv;i++)
	  { fscanf(f,"%*u %f %f %f %u",&a,&b,&c,&k);
	p[i]=(unsigned int)k; x[i]=(float)a; y[i]=(float)b; z[i]=(float)c; r[i]=new unsigned int[k];
	for (j=0;j<k;j++) { fscanf(f,"%u",&R); r[i][j]=(unsigned int)(R-1); } }
  return(*this);
}

  object_3d& object_3d::operator>>(FILE* f)
{ unsigned int i,j;
  fprintf(f,"%6u \n",nv);
  for (i=0;i<nv;i++)
	  { fprintf(f,"%6u %+16.6f %+16.6f %+16.6f %6u", i+1,x[i],y[i],z[i],p[i]);
	for (j=0;j<p[i];j++) fprintf(f,"%6u", r[i][j]+1);
	fprintf(f,"\n");
	  }
  return *this;
}

  void object_3d::cnv()
{ if (nv) { for (unsigned int i=0;i<nv;i++) delete[] r[i];
		delete[] r; delete[] p; delete[] x; delete[] y; delete[] z; nv=0; }
  p=0; r=0;
}

  void rgl(object_3d& g)
{ unsigned int i,j,k,l; unsigned int q, *s;
  for (i=0;i<g.nv;i++)
	  { s=g.r[i];
	for (j=0;j<g.p[i];j++)
		{ q=s[j]; l=j;
		  for (k=j+1;k<g.p[i];k++)
		  if (s[k]<q) { q=s[k]; l=k; }
		  q=s[j]; s[j]=s[l]; s[l]=q;       } }
}

  int object_3d::ver()
{ unsigned int i,j,k,f;
  for(i=0;i<nv;i++)
    { for(j=0;j<p[i];j++)
      { f=0;
	for(k=0;k<p[r[i][j]];k++) if(r[r[i][j]][k]==i) f=1;
	if(f==0) return(1); } }
  return(0);
}
/*----------------------- Procedures & Functions -------------------*/
void coeff(options &op)
{ double th,ph,costh,sinth,cosph,sinph,factor;
  screen_dist=op.d;
  xc=op.xC; yc=op.yC;
  factor=atan(1.0)/45.0;
  th=op.theta*factor; ph=op.phi*factor;
  costh=cos(th);      sinth=sin(th);
  cosph=cos(ph);      sinph=sin(ph);
  v11=-sinth;         v12=-cosph*costh;      v13=-sinph*costh;
  v21=costh;          v22=-cosph*sinth;      v23=-sinph*sinth;
		      v32=sinph;             v33=-cosph;
					     v43=op.rho;
}

void perspective(float x,float y,float z,float &X,float &Y)
{ float xe,ye,ze;
  xe=v11*x+v21*y;
  ye=v12*x+v22*y+v32*z;
  ze=v13*x+v23*y+v33*z+v43;
  X=screen_dist*xe/ze+xc;
  Y=screen_dist*ye/ze+yc;
}
void viewing(float x,float y,float z,float &xe,float &ye,float &ze)
{ xe=v11*x+v21*y;
  ye=v12*x+v22*y+v32*z;
  ze=v13*x+v23*y+v33*z+v43;
}

void mv(float x,float y, float z)
{ float X,Y;
  perspective(x,y,z,X,Y);
  moveto(X,Y);
}

void dw(float x,float y,float z)
{ float X,Y;
  perspective(x,y,z,X,Y);
  lineto(X,Y);
}

void ln(float x1,float y1,float z1,float x2,float y2,float z2)
{ float X1,Y1,X2,Y2;
  perspective(x1,y1,z1,X1,Y1);
  perspective(x2,y2,z2,X2,Y2);
  line(X1,Y1,X2,Y2);
}

void paint(object_3d &ob,options &op)
{ unsigned int i,j;
  coeff(op);
  for(i=0;i<ob.nv;i++)
    for(j=0;j<ob.p[i];j++)
      ln(ob.x[i]-op.xO,ob.y[i]-op.yO,ob.z[i]-op.zO,
	 ob.x[ob.r[i][j]]-op.xO,ob.y[ob.r[i][j]]-op.yO,ob.z[ob.r[i][j]]-op.zO);
}