#include	<conio.h>
#include    <graphics.h>
#include	"Vector3D.h"
#include	"Matrix3D.h"
#include    "Camera.h"

//////////////////// simple geometric structures /////////////////////////

struct	Edge
{
	int	v1, v2;		// vertices indexes
	int	f1, f2;		// facet's indexes
};

struct	Facet
{
	int	 v [4];		// vertices indexes
	Vector3D n;		// normal
};

//////////////////// object-oriented model of unit cube ////////////////////

class	Cube
{
public:
	Vector3D vertices [8];
	Edge	 edges    [12];
	Facet	 facets   [6];

	Cube ();

	void	initEdge ( int i, int v1, int v2, int f1, int f2 )
	{
		edges [i].v1 = v1;
		edges [i].v2 = v2;
		edges [i].f1 = f1;
		edges [i].f2 = f2;
	};

	void	initFacet ( int i, int v1, int v2, int v3, int v4 )
	{
		facets [i].v [0] = v1;
		facets [i].v [1] = v2;
		facets [i].v [2] = v3;
		facets [i].v [3] = v4;
	};

	int	    isFrontFacing ( int facetNo , const Camera& camera ) const
	{
		return ((vertices [facets [facetNo].v [0]] - camera.pos ) & facets [facetNo].n) < 0;
	}

	void	computeNormals ();
	void	applyTransform ( const Vector3D&, const Matrix3D& );
	void	drawShaded     ();
};

/////////////////////////////// Global vars ////////////////////////////

Vector3D eye   ( 0, 0, -5 );		// observer loc
Vector3D lightDir ( 0, 0.7, 0.7 );
Camera   camera ( eye, Vector3D ( 0, 0, 0 ), Vector3D ( 0, 1, 0 ), 640, 350 );

/////////////////////////////// Cube methods /////////////////////////////

Cube :: Cube ()
{
	// 1. init vertices

	for ( int i = 0; i < 8; i++ )
	{
		vertices [i].x = i & 1 ? 1.0 : 0.0;
		vertices [i].y = i & 2 ? 1.0 : 0.0;
		vertices [i].z = i & 4 ? 1.0 : 0.0;
	}

	// 2. init edges

	initEdge ( 0,  0, 1, 2, 4 );
	initEdge ( 1,  1, 3, 1, 4 );
	initEdge ( 2,  3, 2, 3, 4 );
	initEdge ( 3,  2, 0, 0, 4 );
	initEdge ( 4,  4, 5, 2, 5 );
	initEdge ( 5,  5, 7, 1, 5 );
	initEdge ( 6,  7, 6, 3, 5 );
	initEdge ( 7,  6, 4, 0, 5 );
	initEdge ( 8,  0, 4, 0, 2 );
	initEdge ( 9,  1, 5, 1, 2 );
	initEdge ( 10, 3, 7, 1, 3 );
	initEdge ( 11, 2, 6, 0, 3 );

	// 3. init facets

	initFacet ( 0, 4, 6, 2, 0 );
	initFacet ( 1, 1, 3, 7, 5 );
	initFacet ( 2, 0, 1, 5, 4 );
	initFacet ( 3, 6, 7, 3, 2 );
	initFacet ( 4, 2, 3, 1, 0 );
	initFacet ( 5, 4, 5, 7, 6 );
}

void	Cube :: computeNormals ()
{
	for ( int i = 0; i < 6; i++ )
		facets [i].n = (vertices [facets [i].v [1]] - vertices [facets [i].v [0]]) ^
			           (vertices [facets [i].v [2]] - vertices [facets [i].v [1]]);
}

void	Cube :: applyTransform ( const Vector3D& translation, const Matrix3D& transform )
{
	for ( int i = 0; i < 8; i++ )
		vertices [i] = translation + transform * vertices [i];
}


void	Cube :: drawShaded ()
{
	Point	 p [8];
	Point	 contour [4];
	Vector3D v;
	int	 color;


				// project vertices
	for ( int i = 0; i < 8; i++ )
        camera.project ( vertices [i], p [i] );

	computeNormals ();

	for ( i = 0; i < 6; i++ )
		if ( isFrontFacing ( i, camera ) )
        {
			int	color = 8 - 7*( facets [i].n & lightDir );

			for ( int j = 0; j < 4; j++ )
				contour [j] = p [facets [i].v [j]];

			setcolor ( color );
			setfillstyle ( SOLID_FILL, color );
			fillpoly ( 4, (int far *) contour );
		}
}

main ()
{
	Cube		cube;
	int		    drv  = VGA;
	int		    mode = VGAMED;
	palettetype pal;

	cube.applyTransform ( Vector3D ( -0.5, -0.5, -0.5 ), rotateX (M_PI / 6) * rotateZ ( M_PI / 6) );

	initgraph ( &drv, &mode, "" );

	getpalette ( &pal );

	for ( int i = 0; i < pal.size; i++ )
		setrgbpalette ( pal.colors [i], (63*i)/15, (63*i)/15, (63*i)/15 );

	cube.drawShaded ();

	getch ();
	closegraph ();
}
