//
// Simple camera class.
// Makes the transform x'=transf*(x-pos) from world to camera space
// Method project does perspective projection of 3D vector onto the
// screen.
//
// Author: Alex V. Boreskoff
// Last change 06/12/1999
//

#ifndef __CAMERA__
#define __CAMERA__

#include  "Point.h"
#include  "Matrix3D.h"

class     Camera
{
public:
   Vector3D pos;         // camera position
   Matrix3D transf;      // camera transform (from world to camera space)

   Camera ( const Vector3D& p, const Matrix3D& t )
   {
       pos    = p;
       transf = t;
   }

   Camera ( const Vector3D& p, const Vector3D& lookAt, const Vector3D& up,
            float xScale, float yScale );

   void     project ( const Vector3D&, Point& ) const;
};

#endif
