//
// Simple camera class.
// Makes the transform x'=transf*(x-pos) from world to camera space
// Method project does perspective projection of 3D vector onto the
// screen.
//
// Author: Alex V. Boreskoff
// Last change 06/12/1999
//

#include    "Camera.h"

Camera :: Camera ( const Vector3D& p, const Vector3D& lookAt, const Vector3D& up,
            float xScale, float yScale )
{
   Vector3D    v     = lookAt - (pos = p); // direction of view
   float       a     = -(up & v) / (v & v);
   Vector3D    up1   = up + a * v;         // orthonormalize up and v
   Vector3D    right = up ^ v;

   up.normalize ()    *= yScale;
   right.normalize () *= xScale;
   v.normalize ();

   transf [0][0] = right [0];
   transf [0][1] = right [1];
   transf [0][2] = right [2] + xScale / 2;  // of the screen
   transf [1][0] = up    [0];
   transf [1][1] = up    [1];
   transf [1][2] = up    [2] + yScale / 2;  // to move (0,0,z) to center
   transf [2][0] = v     [0];
   transf [2][1] = v     [1];
   transf [2][2] = v     [2];
}

void    Camera :: project ( const Vector3D& v, Point& p ) const
{
    Vector3D vt = transf * (v - pos);

    p.x = (int)(vt.x / vt.z);
    p.y = (int)(vt.y / vt.z );
}

