//
// Simple & quick memory manager
//
// Author: Alex V. Boreskoff
// Last change: 09/12/1999
//

#ifndef __MEMORY_POOL__
#define __MEMORY_POOL__

#include    <assert.h>
#include    <malloc.h>

class   MemoryPool
{
private:
    int    poolSize;
    int    poolPos;
    void * pool;
public:

    MemoryPool ( int size )
    {
        poolSize = size;
        poolPos  = 0;
        pool     = malloc ( size );
    }

    ~MemoryPool ()
    {
        free ( pool );
    }

    void * alloc ( int size )
    {
        int oldPos = poolPos;

        poolPos += size;

        assert ( poolPos < poolSize );

        return oldPos + (char *) pool;
    }

    void    free ( void * ptr ) const
    {

    }

    void * realloc ( void * ptr, int size )
    {
       return alloc ( size );				// ???
    }

    void    reset ()
    {
        poolPos = 0;
    }
};

extern  MemoryPool * pool;

#endif
