//
// Class for simple plane (p,n) + dist = 0
//
// Author: Alex V. Boreskoff
// Last change: 20/10/2000
//
#ifndef __PLANE__
#define __PLANE__

#include    "Vector3D.h"
#include    "Matrix3D.h"

class   Plane
{
public:
    Vector3D n;          // normal vector
    float    dist;       // signed distance along n

    Plane ( const Vector3D& v, float d ): n (v)
    {
        n.normalize ();

        dist = d;
    }

    Plane ( float nx, float ny, float nz, float d ): n (nx, ny, nz)
    {
        n.normalize ();

        dist = d;
    }

    Plane ( const Plane& plane ) : n ( plane.n ), dist ( plane.dist ) {}

    float    f ( const Vector3D& v ) const
    {
        return (v & n) + dist;
    }
                            // mirror position (point), depends on plane posit.
    void    mirrorPos ( Vector3D& v ) const
    {
        v -= (2*((v & n) + dist)) * n;
    }

                            // mirror direction, depends only on plane normal
    void    mirrorDir ( Vector3D& v ) const
    {
        v -= (2*(v & n)) * n;
    }

    void    mirrorPlane ( Plane& plane ) const
    {
        Vector3D p (-plane.dist * plane.n);        // point on plane

        mirrorDir ( plane.n );
        mirrorPos ( p );

        plane.dist = -(p & plane.n);
    }

    void    rotate ( const Matrix3D& rot )
    {
        Vector3D    p ( - dist*n );

        n    = rot * n;
        dist = - (p & n);
    }
};

#endif
