#include    <conio.h>
#include    <dos.h>
#include    <stdio.h>
#include	<time.h>
#include    "Poly3D.h"
#include    "Poly2D.h"
#include    "Pool.h"
#include    "Camera.h"
#include    "Mouse.h"

MemoryPool * pool     = new MemoryPool ( 10240 );
char far   * videoMem = (char far *)MK_FP ( 0xA000, 0 );

void    drawPartiallyLinearMappedPoly ( const Polygon2D& poly, char far * videoMem );

void	setVideoMode ( int mode )
{
	asm {
		mov	ax, mode
		int	10h
	}
}

void    drawPolygon ( const Polygon3D& poly, const Camera& camera, char far * videoMem )
{
    Polygon2D      prj ( poly.numVertices, 1 );

    for ( int      i = 0; i < poly.numVertices; i++ )
    {
        Vector3D    p;

        camera.transform ( poly.vertices [i], p );

        prj.vertices [i].x = p.x / p.z;
        prj.vertices [i].y = p.y / p.z;
        prj.uvMap    [i]   = poly.uvMap [i] / p.z;
    }

    prj.numVertices = 4;
    prj.setTexture ( poly.texture );

    drawPartiallyLinearMappedPoly ( prj, videoMem );
}

main ()
{
    setVideoMode    ( 0x13 );
    resetMouse      ();
    hideMouseCursor ();
    moveMouseCursor ( Point ( 160, 100 ) );

    Texture * tex = new Texture ( 64, 64, "grid" );
                                // build texture
    for ( int i = 0; i < 64; i++ )
        for ( int j = 0; j < 64; j++ )
        {
            int u = i / 8;
            int v = j / 8;

            tex -> data [i*64+j] = ((u+v)&1 ? 1 : 4);
        }

    tex -> widthPower = 6;

    Camera       camera ( "testCamera", Vector3D ( 0, 0, -5 ), Vector3D ( 0, 0, 0 ),
                          Vector3D ( 0, 1, 0 ), 320, 200, 60.0f );

    Polygon3D    poly ( 4, 1 ); // preallocate vertex arrays

    poly.addVertex ( Vector3D ( 1,   1, 1 ), Vector3D ( 63, 63, 1 ) );
    poly.addVertex ( Vector3D ( 1,  -1, 1 ), Vector3D ( 63, 0,  1 ) );
    poly.addVertex ( Vector3D ( -1, -1, 1 ), Vector3D ( 0,  0,  1 ) );
    poly.addVertex ( Vector3D ( -1,  1, 1 ), Vector3D ( 0,  63, 1 ) );

    poly.texture = tex;

    MouseState     mouse;
    MouseState     oldMouse;
	int	           start       = clock ();
    long           totalFrames = 0;
    char         * doubleBuf   = (char *) malloc ( 320*200 );

    if ( doubleBuf == NULL )
       return 1;

    readMouseState ( oldMouse );

    for ( ; ; )
    {
        memset ( doubleBuf, 0, 320*200U );

        readMouseState ( mouse );

        if ( mouse.buttons )
           break;

        if ( kbhit () )
        {
            int ch = getch ();

            if ( ch == 27 )     // escape
                break;

            if ( ch == '+' )    // change field of view (fov)
               camera.setFov ( camera.getFov () + 5 );
            else
            if ( ch == '-' )
               camera.setFov ( camera.getFov () - 5 );
        }

                                // convert mouse movement to yaw/pitch/roll angles
        float     yaw   = (mouse.loc.x - oldMouse.loc.x)*M_PI/300;
        float     pitch = (mouse.loc.y - oldMouse.loc.y)*M_PI/300;
        float     roll  = 0;
        Polygon3D p ( poly );

                                // transform temp poly by YPR matrix
        p.transform ( rotateYPR ( yaw, pitch, roll ) );

                                // draw in to back buffer
        drawPolygon ( p, camera, doubleBuf );

                                // copy back buffer to video memory
        memcpy      ( videoMem, doubleBuf, 320*200 );

        pool -> reset ();       // reset memory pool after all poly ops

        totalFrames++;
    }

	float	totalTime = ( clock () - start ) / CLK_TCK;

	setVideoMode ( 0x03 );

	printf ( "\nFrames rendered    : %7ld",  totalFrames );
	printf ( "\nTotal time ( sec ) : %7.2f", totalTime );
	printf ( "\nFPS                : %7.2f", totalFrames / totalTime );
}
