//
// Basic class for all object hierarchy
// Author: Alex V. Boreskoff
// Last changed: 20/10/2000
//

#ifndef __OBJECT__
#define __OBJECT__

class   Object
{
    char  * name;
    int     refCount;
public:
    Object ( char * aName ) : name ( aName ), refCount ( 1 ) {}
    virtual ~Object () {}

    virtual char  * getClassName () const
    {
        return "Object";
    }

    virtual int isOk () const
    {
        return 1;
    }

    virtual long hash () const
    {
        return 0l;
    }

    virtual int isEqual ( const Object& obj ) const
    {
        return 0;
    }

    void    release ()
    {
        if ( --refCount < 1 )
            delete this;
    }

    Object * retain ()
    {
        refCount++;

        return this;
    }

    char * getName () const
    {
        return name;
    }

    void    setName ( char * newName )
    {
        name = newName;
    }
};

#endif
