//
// 2D bounding box with simple functionality:
//    adjust bbox by adding new vertex,
//    whether this bbox contains another bbox,
//    whether this bbox overalps another bbox
//
// Author: Alex V. Boreskoff
// Last change: 20/10/2000
//

#ifndef __BOUNDING_BOX__
#define __BOUNDING_BOX__

#include    "Vector2D.h"
#include    "3ddefs.h"

class   BoundingBox
{
public:
    float   xMin, yMin;     // minimal x, y values
    float   xMax, yMax;     // maximal x, y values

    BoundingBox ()
    {
        reset ();
    }

    void   reset ()
    {
        xMin = MAX_COORD;
        yMin = MAX_COORD;
        xMax = -MAX_COORD;
        yMax = -MAX_COORD;
    }

    void    addVertex ( const Vector2D& v )
    {
        if ( v.x < xMin )
            xMin = v.x;

        if ( v.x > xMax )
            xMax = v.x;

        if ( v.y < yMin )
            yMin = v.y;

        if ( v.y > yMax )
            yMax = v.y;
    }

    int contain ( const BoundingBox& b ) const
    {
        return xMin <= b.xMin && b.xMax <= xMax &&
               yMin <= b.yMin && b.yMax <= yMax;
    }

    int overlap ( const BoundingBox& b ) const
    {
        return xMax >= b.xMin && xMin <= b.xMax &&
               yMax >= b.yMin && yMin <= b.yMax;
    }

    int isEmpty () const
    {
        return xMin >= xMax || yMin >= yMax;
    }
};

#endif
