#ifndef  __DRIECTDRAW_SURFACE__
#define  __DIRECTDRAW_SURFACE__

#include <windows.h>
#include <ddraw.h>
#include "Surface.h"

class DirectDrawSurface : public Surface
{
    LPDIRECTDRAW            directDrawObject;
    LPDIRECTDRAW2           directDraw2Object;
    LPDIRECTDRAWSURFACE     primarySurface;   // DirectDraw primary surface
    LPDIRECTDRAWSURFACE     backBuffer;       // DirectDraw back surface
    HWND                    hWindow;

public:
    DirectDrawSurface ( HWND );
    ~DirectDrawSurface ();

    virtual  int   isOk () const
    {
        return directDrawObject != NULL && directDraw2Object != NULL &&
               primarySurface != NULL   && backBuffer != NULL &&
               format.bitsPerPixel >= 8;
    }

    virtual  void  beginDraw ();
    virtual  void  endDraw ();

    void  setMode ( int xRes, int yRes, int bitsPerPixel, int refreshRate = 0 );
};

#endif
