#include "DirectDrawSurface.h"

DirectDrawSurface :: DirectDrawSurface ( HWND hWnd ) : Surface ()
{
    directDrawObject  = NULL;
    directDraw2Object = NULL;
    data              = NULL;
    alphaData         = NULL;
    hWindow           = hWnd;

    if ( DirectDrawCreate ( NULL, &directDrawObject, NULL ) != DD_OK )
        return;

    directDrawObject -> SetCooperativeLevel ( hWnd, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN );

    directDrawObject -> QueryInterface ( IID_IDirectDraw2, (void **)&directDraw2Object);

}

DirectDrawSurface :: ~DirectDrawSurface ()
{
   if ( directDrawObject != NULL )
   {
      if ( primarySurface != NULL )
         primarySurface -> Release ();

      if ( directDraw2Object != NULL )
         directDraw2Object -> Release ();

      directDrawObject -> Release ();

      directDrawObject = NULL;
   }
}

void  DirectDrawSurface :: setMode ( int xRes, int yRes, int bitsPerPixel, int refreshRate )
{
    if ( primarySurface != NULL )
        primarySurface -> Release ();

    primarySurface = NULL;
    backBuffer     = NULL;

    if ( directDrawObject == NULL )
        return;

    if ( directDraw2Object -> SetDisplayMode ( xRes, yRes, bitsPerPixel, refreshRate, NULL ) != DD_OK )
        return;

    DDSURFACEDESC       ddsd;
    DDSCAPS             ddscaps;

      		// Create the primary surface with 1 back buffer
    ZeroMemory ( &ddsd, sizeof ( ddsd ) );

    ddsd.dwSize            = sizeof( ddsd );
	ddsd.dwFlags           = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
	ddsd.ddsCaps.dwCaps    = DDSCAPS_PRIMARYSURFACE | DDSCAPS_FLIP | DDSCAPS_COMPLEX;
	ddsd.dwBackBufferCount = 1;

	if ( directDraw2Object -> CreateSurface ( &ddsd, &primarySurface, NULL ) != DD_OK )
        return;

    ddscaps.dwCaps = DDSCAPS_BACKBUFFER;

    primarySurface -> GetAttachedSurface (&ddscaps, &backBuffer );

    DDPIXELFORMAT pf;
    HRESULT       res;

    ZeroMemory ( &pf, sizeof ( pf ) );
    pf.dwSize = sizeof ( pf );

    if ( ( res = backBuffer -> GetPixelFormat ( &pf ) ) == DD_OK )
    {
      format.bitsPerPixel = pf.dwRGBBitCount;
      format.redMask      = pf.dwRBitMask;
      format.greenMask    = pf.dwGBitMask;
      format.blueMask     = pf.dwBBitMask;

      format.completeFromMasks ();
   }
   else
      format.bitsPerPixel = 0;

    width  = xRes;
    height = yRes;

    numFrames        = 1;
    bytesPerScanLine = ddsd.lPitch;
    data             = NULL;
    lineStart        = NULL;
    alphaData        = NULL;
    palette          = NULL;
    curFont          = NULL;
    rasterOp         = RO_COPY;
    color            = 0;
    backColor        = 0;
    transpColor      = -1;           // no transparent color
    frameStart       = 0;
    clipRect.x1      = 0;
    clipRect.y1      = 0;
    clipRect.x2      = width - 1;
    clipRect.y2      = height - 1;
    org.x            = 0;
    org.y            = 0;

    setFuncPointers ();
}

void  DirectDrawSurface :: beginDraw ()
{
   DDSURFACEDESC  ddsd;
   HRESULT        res;

   ZeroMemory ( &ddsd, sizeof ( ddsd ) );

   ddsd.dwSize = sizeof( ddsd );

   for ( ; ; )
   {
        res = backBuffer -> Lock ( NULL, &ddsd, DDLOCK_WAIT | DDLOCK_SURFACEMEMORYPTR, NULL );

        if ( res == DD_OK )
            break;

        if ( res == DDERR_SURFACELOST )
        {
            if ( ( res = primarySurface -> Restore () ) != DD_OK )
                return;         // error
            if ( ( res = backBuffer -> Restore () ) != DD_OK )
                return;         // error
        }

        if ( res != DDERR_WASSTILLDRAWING )
            return;             // error
  }

   data             = ddsd.lpSurface;
   bytesPerScanLine = ddsd.lPitch;

   if ( lineStart == NULL )
   {
        lineStart = new int [height];

        if ( lineStart != NULL )
            for ( int i = 0; i < height; i++ )
                lineStart [i] = i * bytesPerScanLine;
   }
}

void  DirectDrawSurface :: endDraw ()
{
    backBuffer     -> Unlock ( data );
    primarySurface -> Flip ( NULL, DDFLIP_WAIT );

   data = NULL;
}


