//
// Sample test for DibSectionSurface
//
#include    <windows.h>
#include    "DirectDrawSurface.h"

LRESULT CALLBACK wndProc ( HWND, UINT, WPARAM, LPARAM );
HWND    hWindow;
DirectDrawSurface * surf;

int	xc = 100;
int	yc = 100;
int	vx = 1;			// velocity
int	vy = 1;
int active;

void	drawFrame ()
{
	if ( ( xc += vx ) >= surf -> width - 200 || xc < 0 )
	{
		xc -= vx;
		vx  = -vx;
	}

	if ( ( yc += vy ) >= surf -> height - 200 || yc < 0 )
	{
		yc -= vy;
		vy  = -vy;
	}

    surf -> beginDraw ();

    if ( surf -> data == NULL )
        return;

    surf -> setColor  ( rgbToInt ( 0xFF, 0xFF, 0, surf -> format ) );
    surf -> drawBar   (  0, 0, 639, 479 );
    surf -> setColor  ( rgbToInt ( 0, 0, 0xFF, surf -> format ) );
    surf -> drawFrame ( Rect ( xc, yc, xc + 200, yc + 200 ) );
    surf -> drawLine  ( xc, yc, xc + 200, yc + 200 );
    surf -> drawLine  ( xc, yc + 200, xc + 200, yc );
    surf -> endDraw   ();
}

int PASCAL WinMain(HINSTANCE hCurInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
    WNDCLASS    wc;

    wc.hCursor       = LoadCursor ( NULL, IDC_ARROW );
    wc.hIcon         = LoadIcon   ( NULL, IDI_APPLICATION );
    wc.lpszMenuName  = NULL;
    wc.lpszClassName = "DirectDrawTestClass";
    wc.hbrBackground = GetStockObject ( BLACK_BRUSH );
    wc.hInstance     = hCurInstance;
    wc.style         = CS_VREDRAW | CS_HREDRAW;
    wc.lpfnWndProc   = wndProc;
    wc.cbClsExtra    = 0;
    wc.cbWndExtra    = 0;

    if ( !RegisterClass ( &wc ) )
        return 0;

    hWindow =CreateWindowEx ( WS_EX_APPWINDOW, "DirectDrawTestClass",
                              "DirectDrawSurface Test",
                              WS_POPUP |WS_SYSMENU,
                              0, 0, 640, 480,
                              0, 0, hCurInstance, 0 );

    ShowWindow   ( hWindow, nCmdShow );
    UpdateWindow ( hWindow );

    surf = new DirectDrawSurface ( hWindow );

    surf -> setMode ( 640, 480, 16 );

    if ( !surf -> isOk () )
        return 0;

    MSG msg;

    for ( ; ; )
    {
        if ( PeekMessage ( &msg, NULL, 0, 0, PM_NOREMOVE ) )
        {
            if ( !GetMessage ( &msg, NULL, 0, 0 ) )
                return msg.wParam;

            TranslateMessage ( &msg );
            DispatchMessage  ( &msg );
        }
        else
        if ( active )
            drawFrame ();
    }
}

LRESULT CALLBACK wndProc ( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
    switch ( msg )
    {
        case WM_ACTIVATEAPP:
            active = wParam;
            break;

        case WM_SETCURSOR:
            SetCursor ( NULL );
            return TRUE;
            
        case WM_KEYDOWN:
            if ( wParam == VK_ESCAPE )
                PostMessage ( hWnd, WM_CLOSE, 0, 0 );
            break;

        case WM_DESTROY:
            delete surf;
            PostQuitMessage ( 0 );
            break;
    }

    return DefWindowProc ( hWnd, msg, wParam, lParam );
}

