#include "Vector.h"

double N ( int n, int i, double u, double knot[] )
{
	if ( n == 0 )
		return ( knot [i] <= u && u < knot [i+1] ) ? 1.0 : 0.0;
	else
		return  ( u - knot [i] ) * N ( n-1, i, u, knot ) / (knot [i+n] - knot [i]) +
			( knot [i+n+1] - u ) * N ( n-1, i+1, u, knot ) / (knot [i+n+1] - knot [i+1]);
}

Vector	Nurbs_3_3 ( Vector p [], double w [], double uknot [], double vknot [], int k, int l,
		int n, double u, double v )
{
	Vector	z ( 0 );
	double	t, s2 = 0;

	for ( int i = k - 3; i < k + 1; i++ )
	{
		double s1 = 0 ;
		Vector	q ( 0 );

		for ( int j = l - 3; j < l + 1; j++ )
		{
			t  = N ( 3, j, v, vknot ) * w [ i*n + j ];
			s1 = s1 + t;
			q += t * p [ i*n + j];
		}

		t  = N ( 3, i, u, uknot );
		s2 = s2 + t * s1;
		z += t * q;
    }

	return z / s2;
}
