#include "Vector.h"

double B ( int i, double t )
{
	double s = 1.0 - t;

	switch( i )
	{
		case 0:
			return s * s * s;

		case 1:
			return 3 * t * s * s;

		case 2:
			return 3 * t * t * s;

		case 3:
			return t * t * t;
	}
}

Vector	Bezier_3_3 ( Vector p [], int n, double u, double v, int i, int j )
{
	Vector	t ( 0 );

	for ( int k = 0; k < 4; k++ )
	{
		Vector	s ( 0 );

		for ( int l = 0; l < 4; l++ )
			s += B ( l, v ) * p [ (i+k)*n + j+l ];

		t += B ( k, u ) * s;
	}

	return t;
}
