#include	<math.h>
#include	"Vector.h"

static double beta1, beta2;
static double b12, b13, b22, b23;
static double delta, d;

double b ( int i, double t )
{
	double s = 1.0 - t;
	double t2 = t * t;
	double t3 = t2 * t;

	switch ( i )
	{
		case 0:
			return 2 * b13 * d * s * s * s;

		case 1:
			return d*(2*b13*t*(t2-3*t+3)+2*b12*(t3-3*t2+2)+2*beta1*(t3-3*t+2)+beta2*(2*t3-3*t2+1));

		case 2:
			return d*( 2*b12*t2*(-t+3) + 2*beta1*t*(-t2+3)+beta2*t2*(-2*t+3)+2*(-t3+1));

		case 3:
			return 2 * t3 * d;
	}
}

Vector	Beta_3_3 ( double b1, double b2, Vector p [], int n, double u, double v, int i, int j )
{
	Vector	t ( 0 );

	beta1 = b1;
	beta2 = b2;
	b12   = beta1 * beta1;
	b13   = b12 * beta1;
	b22   = beta2 * beta2;
	b23   = b22 * beta2;

	delta = 2 * b13 + 4 * b12 + 4 * beta1 + beta2 + 2;
	d     = 1.0 / delta;

	for ( int k = 0; k < 4; k++ )
	{
		Vector	s ( 0 );

		for ( int l = 0; l < 4; l++ )
			s += p [ (i+k) * n + j + l ] * b ( l, v );

		t += s * b ( k, u );
	}

	return t;
}
