#include	<math.h>

double N ( int n, int i, double u, double knot [] )
{
	if ( n == 0 )
		return ( knot [i] <= u && u < knot [i+1] ) ? 1.0 : 0.0;

	return  ( u - knot [i] ) * N ( n-1, i, u, knot ) / ( knot [i+n] - knot [i] ) +
		( knot [i+n+1] - u ) * N ( n-1, i+1, u, knot ) / ( knot [i+n+1] - knot [i+1] );
}

double Nurbs ( double p [], double w [], double knot [], int j, double u )
{
	double	s1 = 0,
		s2 = 0;

	for ( int i = j - 3; i < j + 1; i++ )
	{
		double tt = N ( 3, i, u, knot ) * w [i];

		s1 += tt * p [i];
		s2 += tt;
	}

	return s1 / s2 ;
}
