#include <math.h>

double BetaSpline ( double beta1, double beta2, double p [], int i, double t )
{
	double	s  = 1.0 - t;
	double	t2 = t * t;
	double	t3 = t2 * t;
	double	b12 = beta1 * beta1;
	double	b13 = b12 * beta1;
	double	delta = 2.0 * b13 + 4.0 * b12 + 4.0 * beta1 + beta2 + 2.0;
	double	d = 1.0 / delta;
	double	b0 = 2 * b13 * d * s * s * s;
	double	b3 = 2 * t3 * d;
	double	b1 = d * (2*b13*t*(t2-3*t+3)+2*b12*(t3-3*t2+2)+2*beta1*(t3-3*t+2)+beta2*(2*t3-3*t2+1));
	double	b2 = d * (2*b12*t2*(-t+3) + 2*beta1*t*(-t2+3)+beta2*t2*(-2*t+3)+2*(-t3+1));

	return b0*p [i] + b1*p [i+1] + b2*p [i+2] + b3*p [i+3];
}

