/////////////////////////////////////////////////////////
// Sample program to book                              //
//  Computer Graphics : Dynamics & Realistic Imaging.  //
//      by A.V. Boreskoff, E.V. Shikin                 //
//                                                     //
// Author:                                             //
//    Alex V. Boreskoff                                //
//                                                     //
// E-mail:                                             //
//    alex@garser.msk.su                               //
/////////////////////////////////////////////////////////

#include	"Tracer.h"
#include	"Geometry.h"
#include	"Render.h"
#include	"Map.h"
#include	"Bmp.h"
#include	"Colors.h"
#include	"PlaneMap.h"

main ()
{
	Box        * b      = new Box ( Vector ( 0, -2, 5 ), Vector ( 8, 0, 3 ), Vector ( -8, 0, 3 ), Vector ( 0, -3, 0 ) );
	PointLight * Light1 = new PointLight ( Vector ( 7, 10, -10 ), 20 );
	BMPImage   * img    = new BMPImage ( "256color.bmp" );
	ColorMap   * cmap   = new ColorMap ( img );

	cmap -> Scale = 25;

	Scene  = new Environment ();

	b -> Mapping = new PlaneMap ( Vector ( 0, -1, -1 ), Vector ( 1, 0, 0 ) );
	b -> Add ( cmap );
	b -> DefMaterial.Ka    = 0.3;
	b -> DefMaterial.Kd    = 0.8;
	b -> DefMaterial.Ks    = 0.3;
	b -> DefMaterial.Kr    = 0.0;
	b -> DefMaterial.Kt    = 0.0;
	b -> DefMaterial.p     = 5;
	b -> DefMaterial.Med   = Glass;
	b -> DefMaterial.Color = 1;

	Scene -> Add ( b );
	Scene -> Add ( Light1 );

	Background = SkyBlue;
	SetCamera ( Vector ( 0 ), Vector ( 0, 0, 1 ), Vector ( 0, 1, 0 ) );
	RenderScene ( 1.5, 1.0, 300, 200, "SAMPLE7.TGA" );
}
