/////////////////////////////////////////////////////////
// Sample program to book                              //
//  Computer Graphics : Dynamics & Realistic Imaging.  //
//      by A.V. Boreskoff, E.V. Shikin                 //
//                                                     //
// Author:                                             //
//    Alex V. Boreskoff                                //
//                                                     //
// E-mail:                                             //
//    alex@garser.msk.su                               //
/////////////////////////////////////////////////////////

#include	"Tracer.h"
#include	"Geometry.h"
#include	"Render.h"
#include	"Colors.h"
#include	"Wood.h"

main ()
{
	Box        * b = new Box ( Vector ( -1, -1, -2 ), Vector ( 2, 0, 0 ), Vector ( 0, 2, 0 ), Vector ( 0, 0, 4 ) );
	PointLight * Light1, * Light2;

	Scene = new Environment ();

	b -> DefMaterial.Ka    = 0.3;
	b -> DefMaterial.Kd    = 0.7;
	b -> DefMaterial.Ks    = 0.5;
	b -> DefMaterial.Kr    = 0.0;
	b -> DefMaterial.Kt    = 0.0;
	b -> DefMaterial.p     = 30;
	b -> DefMaterial.Color = Yellow;
	b -> DefMaterial.Med   = Glass;
	b -> Add ( new Wood ( 35, 6, 5 ) );

	Light1 = new PointLight ( Vector ( 10, 5, -10 ), 17 );
	Light2 = new PointLight ( Vector ( -10, -5, -10 ), 17 );

	Scene -> Add ( b );
	Scene -> Add ( Light1 );
	Scene -> Add ( Light2 );

	Background = SkyBlue;

	InitNoise ();
	SetCamera ( Vector ( -4, 8, -4 ), Vector ( 2, -5, 2 ), Vector ( 0, 1, 0 ) );
	RenderScene ( 1.5, 1.0, 300, 200, "SAMPLE5.TGA" );
}
