#include	"Vector.h"
#include	"Tracer.h"
#include	"Render.h"
#include	"Geometry.h"
#include	"Colors.h"
#include	"Checker.h"

main ()
{
	Plane      * p;
	Sphere     * s [16];
	PointLight * Light1;
	int	     i, j, k;

	Scene  = new Environment ();

	p = new Plane ( 0, 0, 1, -7.1 );

	p -> DefMaterial.Ka    = 0.8;
	p -> DefMaterial.Kd    = 0.2;
	p -> DefMaterial.Ks    = 0.1;
	p -> DefMaterial.Kr    = 0.0;
	p -> DefMaterial.Kt    = 0.0;
	p -> DefMaterial.p     = 30;
	p -> DefMaterial.Color = White;
	p -> DefMaterial.Med   = Glass;

	p -> Add ( new Checker ( White, Black ) );

	p -> Material -> Scale = 3;

	Scene -> Add ( p );

	for ( i = k = 0; i < 4; i++ )
		for ( j = 0; j < 4; j++, k++ )
		{
			s [k] = new Sphere ( Vector ( -3 + j*2, 2.15 - i*1.45,  5 ), 0.7 );

			if ( i > 0 )
				s [k] -> DefMaterial.Ka = 0.2;
			else
				s [k] -> DefMaterial.Ka = j * 0.33;

			if ( i < 1 )
				s [k] -> DefMaterial.Kd = 0;
			else
			if ( i == 1 )
				s [k] -> DefMaterial.Kd = j * 0.33;
			else
				s [k] -> DefMaterial.Kd = 0.4;

			if ( i < 2 )
				s [k] -> DefMaterial.Ks = 0;
			else
			if ( i == 2 )
				s [k] -> DefMaterial.Ks = j * 0.33;
			else
				s [k] -> DefMaterial.Ks = 0.7;

			if ( i < 3 )
			{
				s [k] -> DefMaterial.Med.nRefr = 1.0;
				s [k] -> DefMaterial.Kt        = 0.0;
			}
			else
			{
				s [k] -> DefMaterial.Med.nRefr = 1.0 + j * 0.05;
				s [k] -> DefMaterial.Kt        = 0.8;
			}

			s [k] -> DefMaterial.p  = 20;
			s [k] -> DefMaterial.Kr = 0;
			s [k] -> DefMaterial.Color = Green;
			s [k] -> DefMaterial.Med.Betta = 0;

			Scene -> Add ( s [k] );
		}

	Light1 = new PointLight ( Vector ( 10, 5, -10 ), 15 );

	Scene -> Add  ( Light1 );

	Background = SkyBlue;
	SetCamera ( Vector ( 0, 0, -10 ), Vector ( 0, 0, 1 ), Vector ( 0, 1, 0 ) );
	RenderScene ( 0.3, 0.2, 300, 200, "SAMPLE12.TGA" );
}
