/////////////////////////////////////////////////////////
// Sample program to book                              //
//  Computer Graphics : Dynamics & Realistic Imaging.  //
//      by A.V. Boreskoff, E.V. Shikin                 //
//                                                     //
// Author:                                             //
//    Alex V. Boreskoff                                //
//                                                     //
// E-mail:                                             //
//    alex@garser.msk.su                               //
/////////////////////////////////////////////////////////

#include	"Tracer.h"
#include	"Geometry.h"
#include	"Render.h"
#include	"Map.h"
#include	"Bmp.h"
#include	"Colors.h"
#include	"PlaneMap.h"

main ()
{
	Rect       * b      = new Rect ( Vector ( -1, 1, 1.5 ), Vector ( 2, 0, 0 ), Vector ( 0, -2, 0 ) );
	PointLight * Light1 = new PointLight ( Vector ( 7, 10, -10 ), 20 );
	BMPImage   * img    = new BMPImage ( "pic.bmp" );
	BumpMap    * bmap   = new BumpMap ( img, 1 );

	bmap -> Scale = Vector ( 63, -63, 0 );
	bmap -> Offs  = Vector ( 63,  63, 0 );

	Scene  = new Environment ();

	b -> Mapping = new PlaneMap ( Vector ( 0, 0, 1 ), Vector ( 1, 0, 0 ) );
	b -> Add ( bmap );
	b -> DefMaterial.Ka    = 0.3;
	b -> DefMaterial.Kd    = 0.8;
	b -> DefMaterial.Ks    = 0.3;
	b -> DefMaterial.Kr    = 0.0;
	b -> DefMaterial.Kt    = 0.0;
	b -> DefMaterial.p     = 5;
	b -> DefMaterial.Med   = Glass;
	b -> DefMaterial.Color = Blue;

	Scene -> Add ( b );
	Scene -> Add ( Light1 );

	Background = SkyBlue;
	SetCamera ( Vector ( 0 ), Vector ( 0, 0, 1 ), Vector ( 0, 1, 0 ) );
	RenderScene ( 1.5, 1.0, 300, 200, "SAMPLE10.TGA" );
}
