/////////////////////////////////////////////////////////
// Sample program to book                              //
//  Computer Graphics : Dynamics & Realistic Imaging.  //
//      by A.V. Boreskoff, E.V. Shikin                 //
//                                                     //
// Author:                                             //
//    Alex V. Boreskoff                                //
//                                                     //
// E-mail:                                             //
//    alex@garser.msk.su                               //
/////////////////////////////////////////////////////////

#ifndef	__BVH__
#define	__BVH__

#include	"tracer.h"

class	BoundingVolume
{
public:
	BoundingVolume   * next;
        BoundingVolume   * sub;
        GeometricObject ** ObjList;
        int                ObjCount;
        int		   ObjLimit;

        BoundingVolume ();
        ~BoundingVolume ();

        void		  AddObject ( GeometricObject * );
        void		  AddVolume ( BoundingVolume  * );
        GeometricObject	* Intersect ( Ray&, Float& );

        virtual	int	  CheckVolume ( Ray& ) = 0;
};

class	SphericVolume : public BoundingVolume
{
public:
	Vector	Loc;
        Float	Radius;
        Float	Radius2;

        SphericVolume ( Vector& l, Float r ) : BoundingVolume () { Loc = l; Radius = r; Radius2 = r*r; };

        virtual	int	CheckVolume ( Ray& );
};

#endif
