/////////////////////////////////////////////////////////
// Sample program to book                              //
//  Computer Graphics : Dynamics & Realistic Imaging.  //
//      by A.V. Boreskoff, E.V. Shikin                 //
//                                                     //
// Author:                                             //
//    Alex V. Boreskoff                                //
//                                                     //
// E-mail:                                             //
//    alex@garser.msk.su                               //
/////////////////////////////////////////////////////////

#include	<conio.h>
#include	<graphics.h>
#include	<math.h>
#include	<process.h>
#include	<stdio.h>
#include	<stdlib.h>

#include	"Vector.h"

#define	NO_VALUE	7777

struct	Point2			// screen point
{
	int	x, y;
};

void	PlotShadedSurface ( double x1, double y1, double x2, double y2, double (*f)( double, double ), double fmin, double fmax, int n1, int n2 )
{
	Point2 * CurLine  = new Point2 [n1];
	Point2 * NextLine = new Point2 [n1];
	Vector * CurPoint = new Vector [n1];
	Vector * NextPoint= new Vector [n1];
	double   phi      = 30*3.1415926/180;
	double   psi      = 20*3.1415926/180;
	double	 sphi     = sin ( phi );
	double	 cphi     = cos ( phi );
	double	 spsi     = sin ( psi );
	double	 cpsi     = cos ( psi );
	Vector	 e1 ( cphi, sphi, 0 );
	Vector	 e2 ( spsi*sphi, -spsi*cphi, cpsi );
	Vector	 e3 ( sphi*cpsi, -cphi*cpsi, -spsi );
	double   xmin     = ( e1 [0] >= 0 ? x1 : x2 )  * e1 [0] + ( e1 [1] >= 0 ? y1 : y2 ) * e1 [1];
	double   xmax     = ( e1 [0] >= 0 ? x2 : x1 )  * e1 [0] + ( e1 [1] >= 0 ? y2 : y1 ) * e1 [1];
	double   ymin     = ( e2 [0] >= 0 ? x1 : x2 )  * e2 [0] + ( e2 [1] >= 0 ? y1 : y2 ) * e2 [1];
	double   ymax     = ( e2 [0] >= 0 ? x2 : x1 )  * e2 [0] + ( e2 [1] >= 0 ? y2 : y1 ) * e2 [1];
	double	 hx       = ( x2 - x1 ) / n1;
	double	 hy       = ( y2 - y1 ) / n2;
	Vector	 Edge1, Edge2, n;
	Point2	 facet [3];
	double   x, y;
	int	 color;
	int	 i, j, k;

	if ( e2 [2] >= 0 )
	{
		ymin += fmin * e2 [2];
		ymax += fmax * e2 [2];
	}
	else
	{
		ymin += fmax * e2 [2];
		ymax += fmin * e2 [2];
	}

	double	ax = 20 - 600 * xmin / ( xmax - xmin );
	double	bx = 600 / ( xmax - xmin );
	double	ay = 40 - 400 * ymin / ( ymax - ymin );
	double	by = -400 / ( ymax - ymin );

	for ( i = 0; i < 64; i++ )
	{
		setrgbpalette ( i,      0, 0, i );
		setrgbpalette ( 64 + i, 0, i, 0 );
        }

	for ( i = 0; i < n1; i++ )
	{
		CurPoint [i].x = x1 + i * hx;
		CurPoint [i].y = y1;
		CurPoint [i].z = f ( CurPoint [i].x, CurPoint [i].y );
		CurLine [i].x = (int)( ax + bx * ( CurPoint [i] & e1 ) );
		CurLine [i].y = (int)( ay + by * ( CurPoint [i] & e2 ) );
	}

	for ( i = 1; i < n2; i++ )
	{
		for ( j = 0; j < n1; j++ )
		{
			NextPoint [j].x = x1 + j * hx;
			NextPoint [j].y = y1 + i * hy;
			NextPoint [j].z = f ( NextPoint [j].x, NextPoint [j].y );
			NextLine [j].x = (int)( ax + bx * ( NextPoint [j] & e1 ) );
			NextLine [j].y = (int)( ay + by * ( NextPoint [j] & e2 ) );
		}

		for ( j = 0; j < n1 - 1; j++ )
		{
						// draw 1st triangle
			Edge1 = CurPoint [j+1] - CurPoint [j];
			Edge2 = NextPoint [j]  - CurPoint [j];
			n     = Edge1 ^ Edge2;

			if ( ( n & e3 ) >= 0 )
				color = 64 + (int)( 20 + 43 * ( n & e3 ) / !n );
			else
				color = (int)( 20 - 43 * ( n & e3 ) / !n );

			setfillstyle ( SOLID_FILL, color );
			setcolor ( color );

			facet [0] = CurLine [j];
			facet [1] = CurLine [j+1];
			facet [2] = NextLine [j];

			fillpoly ( 3, ( int far * ) facet );

						// draw 2nd triangle
			Edge1 = NextPoint [j+1] - CurPoint [j+1];
			Edge2 = NextPoint [j]   - CurPoint [j+1];
			n     = Edge1 ^ Edge2;

			if ( ( n & e3 ) >= 0 )
			{
				color = 127;
				color = 64 + (int)( 20 + 43 * ( n & e3 ) / !n );
			}
			else
			{
				color = 63;
				color = (int)( 20 - 43 * ( n & e3 ) / !n );

			}

			setfillstyle ( SOLID_FILL, color );
			setcolor ( color );

			facet [0] = CurLine  [j+1];
			facet [1] = NextLine [j];
			facet [2] = NextLine [j+1];

			fillpoly ( 3, ( int far * ) facet );
		}

		for ( j = 0; j < n1; j++ )
		{
			CurLine  [j] = NextLine [j];
			CurPoint [j] = NextPoint [j];
		}
	}

	delete CurLine;
	delete NextLine;
	delete CurPoint;
	delete NextPoint;
}

double	f ( double x, double y )
{
	double	r =  x*x + y*y;

//	return 0.5*sin(2*x)*sin(2*y);
//	return cos ( 2.2*r ) / ( r + 1 );
//	return sin ( r ) / ( r + 1 );
	return cos ( r ) / ( r + 1 );
}

double	f2 ( double x, double y )
{
	double	r =  x*x + y*y;
//	return 0;
//	return cos ( 2.2*r ) / ( r + 1 );
	return cos ( r ) / ( r + 1 );	// good also
}


main ()
{
	int	driver;
	int	mode;
	int	res;

	if ( ( driver = installuserdriver ( "VESA", NULL ) ) == grError )
	{
		printf ( "\nCannot load extended driver" );
		exit ( 1 );
	}

	initgraph ( &driver, &mode, "" );
	if ( ( res = graphresult () ) != grOk )
	{
		printf("\nGraphics error: %s\n", grapherrormsg ( res) );
		exit ( 1 );
	}

	PlotShadedSurface ( -2, -2, 2, 2, f2, -0.5, 1, 30, 30 );

	getch ();
	closegraph ();
}
