/////////////////////////////////////////////////////////
// Sample program to book                              //
//  Computer Graphics : Dynamics & Realistic Imaging.  //
//      by A.V. Boreskoff, E.V. Shikin                 //
//                                                     //
// Author:                                             //
//    Alex V. Boreskoff                                //
//                                                     //
// E-mail:                                             //
//    alex@garser.msk.su                               //
/////////////////////////////////////////////////////////

#include	<conio.h>
#include	<graphics.h>
#include	<math.h>
#include	<process.h>
#include	<stdio.h>
#include	<stdlib.h>

#define	NO_VALUE	7777

struct	Point2			// screen point
{
	int	x, y;
};

int	YMax [640];
int	YMin [640];
int	UpColor   = LIGHTGREEN;
int	DownColor = LIGHTGRAY;

void	DrawLine ( Point2& p1, Point2& p2 )
{
	int	dx = abs ( p2.x - p1.x );
	int	dy = abs ( p2.y - p1.y );
	int	sx = p2.x >= p1.x ? 1 : -1;
	int	sy = p2.y >= p1.y ? 1 : -1;

	if ( dy <= dx )
	{
		int	d  = -dx;
		int	d1 = dy << 1;
		int	d2 = ( dy - dx ) << 1;

		for ( int x = p1.x, y = p1.y, i = 0; i <= dx; i++, x += sx )
		{
			if ( YMin [x] == NO_VALUE ) // YMin, YMax not inited
			{
				putpixel ( x, y, UpColor );
				YMin [x] = YMax [x] = y;
			}
			else
			if ( y < YMin [x] )
			{
				putpixel ( x, y, UpColor );
				YMin [x] = y;
			}
			else
			if ( y > YMax [x] )
			{
				putpixel ( x, y, DownColor );
				YMax [x] = y;
			}

			if ( d > 0 )
			{
				d += d2;
				y += sy;
			}
			else
				d += d1;
		}
	}
	else
	{
		int	d  = -dy;
		int	d1 = dx << 1;
		int	d2 = ( dx - dy ) << 1;
		int	m1 = YMin [p1.x];
		int	m2 = YMax [p1.x];

		for ( int x = p1.x, y = p1.y, i = 0; i <= dy; i++, y += sy )
		{
			if ( YMin [x] == NO_VALUE ) // YMin, YMax not inited
			{
				putpixel ( x, y, UpColor );
				YMin [x] = YMax [x] = y;
			}
			else
			if ( y < m1 )
			{
				putpixel ( x, y, UpColor );
				if ( y < YMin [x] )
					YMin [x] = y;
			}
			else
			if ( y > m2 )
			{
				putpixel ( x, y, DownColor );
				if ( y > YMax [x] )
					YMax [x] = y;
			}

			if ( d > 0 )
			{
				d += d2;
				x += sx;
				m1 = YMin [x];
				m2 = YMax [x];
			}
			else
				d += d1;
		}
	}
}

void	PlotSurface ( double x1, double y1, double x2, double y2, double (*f)( double, double ), double fmin, double fmax, int n1, int n2 )
{
	Point2 * CurLine  = new Point2 [n1];
	double   phi = 30*3.1415926/180;
	double   psi = 10*3.1415926/180;
	double	 sphi = sin ( phi );
	double	 cphi = cos ( phi );
	double	 spsi = sin ( psi );
	double	 cpsi = cos ( psi );
	double	 e1 [] = { cphi, sphi, 0 };
	double	 e2 [] = { spsi*sphi, -spsi*cphi, cpsi };
	double   x, y;
	double	 hx = ( x2 - x1 ) / n1;
	double	 hy = ( y2 - y1 ) / n2;
	double   xmin = ( e1 [0] >= 0 ? x1 : x2 )  * e1 [0] + ( e1 [1] >= 0 ? y1 : y2 ) * e1 [1];
	double   xmax = ( e1 [0] >= 0 ? x2 : x1 )  * e1 [0] + ( e1 [1] >= 0 ? y2 : y1 ) * e1 [1];
	double   ymin = ( e2 [0] >= 0 ? x1 : x2 )  * e2 [0] + ( e2 [1] >= 0 ? y1 : y2 ) * e2 [1];
	double   ymax = ( e2 [0] >= 0 ? x2 : x1 )  * e2 [0] + ( e2 [1] >= 0 ? y2 : y1 ) * e2 [1];
	int	 i, j, k;

	if ( e2 [2] >= 0 )
	{
		ymin += fmin * e2 [2];
		ymax += fmax * e2 [2];
	}
	else
	{
		ymin += fmax * e2 [2];
		ymax += fmin * e2 [2];
	}

	double	ax = 10 - 600 * xmin / ( xmax - xmin );
	double	bx = 600 / ( xmax - xmin );
	double	ay = 10 - 300 * ymin / ( ymax - ymin );
	double	by = -300 / ( ymax - ymin );

	for ( i = 0; i < sizeof ( YMax ) / sizeof ( int ); i++ )
		YMin [i] = YMax [i] = NO_VALUE;

	for ( i = n2 - 1; i > -1; i-- )
	{
		for ( j = 0; j < n1; j++ )
		{
			x = x1 + j * hx;
			y = y1 + i * hy;
			CurLine [j].x = (int)( ax + bx * ( x * e1 [0] + y * e1 [1] ) );
			CurLine [j].y = (int)( ay + by * ( x * e2 [0] + y * e2 [1] + f ( x, y ) * e2 [2] ) );
		}

		for ( j = 0; j < n1 - 1; j++ )
			DrawLine ( CurLine [j], CurLine [j + 1] );
	}

	delete CurLine;
}

void	PlotSurface2 ( double x1, double y1, double x2, double y2, double (*f)( double, double ), double fmin, double fmax, int n1, int n2 )
{
	Point2 * CurLine  = new Point2 [n1];
	Point2 * NextLine = new Point2 [n1];
	double   phi = 30*3.1415926/180;
	double   psi = 10*3.1415926/180;
	double	 sphi = sin ( phi );
	double	 cphi = cos ( phi );
	double	 spsi = sin ( psi );
	double	 cpsi = cos ( psi );
	double	 e1 [] = { cphi, sphi, 0 };
	double	 e2 [] = { spsi*sphi, -spsi*cphi, cpsi };
	double   x, y;
	double	 hx = ( x2 - x1 ) / n1;
	double	 hy = ( y2 - y1 ) / n2;
	double   xmin = ( e1 [0] >= 0 ? x1 : x2 )  * e1 [0] + ( e1 [1] >= 0 ? y1 : y2 ) * e1 [1];
	double   xmax = ( e1 [0] >= 0 ? x2 : x1 )  * e1 [0] + ( e1 [1] >= 0 ? y2 : y1 ) * e1 [1];
	double   ymin = ( e2 [0] >= 0 ? x1 : x2 )  * e2 [0] + ( e2 [1] >= 0 ? y1 : y2 ) * e2 [1];
	double   ymax = ( e2 [0] >= 0 ? x2 : x1 )  * e2 [0] + ( e2 [1] >= 0 ? y2 : y1 ) * e2 [1];
	int	 i, j, k;

	if ( e2 [2] >= 0 )
	{
		ymin += fmin * e2 [2];
		ymax += fmax * e2 [2];
	}
	else
	{
		ymin += fmax * e2 [2];
		ymax += fmin * e2 [2];
	}

	double	ax = 10 - 600 * xmin / ( xmax - xmin );
	double	bx = 600 / ( xmax - xmin );
	double	ay = 10 - 400 * ymin / ( ymax - ymin );
	double	by = -400 / ( ymax - ymin );

	for ( i = 0; i < sizeof ( YMax ) / sizeof ( int ); i++ )
		YMin [i] = YMax [i] = NO_VALUE;

	for ( i = 0; i < n1; i++ )
	{
		x = x1 + i * hx;
		y = y1 + ( n2 - 1 ) * hy;
		CurLine [i].x = (int)( ax + bx * ( x * e1 [0] + y * e1 [1] ) );
		CurLine [i].y = (int)( ay + by * ( x * e2 [0] + y * e2 [1] + f ( x, y ) * e2 [2] ) );
	}

	for ( i = n2 - 1; i > -1; i-- )
	{
		for ( j = 0; j < n1 - 1; j++ )
			DrawLine ( CurLine [j], CurLine [j + 1] );

		if ( i > 0 )
			for ( j = 0; j < n1; j++ )
			{
				x = x1 + j * hx;
				y = y1 + ( i - 1 ) * hy;
				NextLine [j].x = (int)( ax + bx * ( x * e1 [0] + y * e1 [1] ) );
				NextLine [j].y = (int)( ay + by * ( x * e2 [0] + y * e2 [1] + f ( x, y ) * e2 [2] ) );

				DrawLine ( CurLine [j], NextLine [j] );
				CurLine [j] = NextLine [j];
			}
	}

	delete CurLine;
	delete NextLine;
}

double	f ( double x, double y )
{
	double	r =  x*x + y*y;

//	return 0.5*sin(2*x)*sin(2*y);
//	return cos ( 2.2*r ) / ( r + 1 );
//	return sin ( r ) / ( r + 1 );
	return cos ( r ) / ( r + 1 );
}

double	f2 ( double x, double y )
{
	double	r =  x*x + y*y;

	return cos ( 2.2*r ) / ( r + 1 );
//	return cos ( r ) / ( r + 1 );	// good also
}


main ()
{
	int	driver = DETECT;
	int	mode;
	int	res;

	initgraph ( &driver, &mode, "" );
	if ( ( res = graphresult () ) != grOk )
	{
		printf("\nGraphics error: %s\n", grapherrormsg ( res) );
		exit ( 1 );
	}

//	PlotSurface ( -2, -2, 2, 2, f, -0.5, 1, 20, 20 );
	PlotSurface2 ( -2, -2, 2, 2, f2, -0.5, 1, 40, 40 );

	getch ();
	closegraph ();
}
