/////////////////////////////////////////////////////////
// Sample program to book                              //
//  Computer Graphics : Dynamics & Realistic Imaging.  //
//      by A.V. Boreskoff, E.V. Shikin                 //
//                                                     //
// Author:                                             //
//    Alex V. Boreskoff                                //
//                                                     //
// E-mail:                                             //
//    alex@garser.msk.su                               //
/////////////////////////////////////////////////////////

#include	<alloc.h>
#include	<conio.h>
#include	<mem.h>
#include	<stdio.h>
#include	"Ega.h"

unsigned   PageBase = 0;
int	   BytesPerLine;
char       LeftPlaneMask  [] = { 0x0F, 0x0E, 0x0C, 0x08 };
char	   RightPlaneMask [] = { 0x01, 0x03, 0x07, 0x0F };
char far * Font;

void	SetX320x240 ()
{
	static int CRTCTable [] = {
		0x0D06,  		// vertical total
		0x3E07,  	        // overflow (bit 8 of vertical counts)
		0x4109,  		// cell height (2 to double-scan)
		0xEA10,  		// vert sync start
		0xAC11,			// vert sync end and protect cr0-cr7
		0xDF12,  		// vertical displayed
		0x0014,  		// turn off dword mode
		0xE715,  		// vert blank start
		0x0616,  		// vert blank end
		0xE317  		// turn on byte mode
	};

	SetVideoMode ( 0x13 );

	PageBase     = 0xA000;
	BytesPerLine = 80;
	WriteReg ( EGA_SEQUENCER, 4, 6 );
	WriteReg ( EGA_CRTC, 0x17, 0xE3 );
	WriteReg ( EGA_CRTC, 0x14, 0 );

	WriteReg ( EGA_SEQUENCER, 0, 1 );	// synchronous reset
	outportb ( 0x3C2, 0xE3 );		// select 25 MHz dot clock
						// & 60 Hz scan rate
	WriteReg ( EGA_SEQUENCER, 0, 3 );	// restart sequencer
	WriteReg ( EGA_CRTC, 0x11, ReadReg ( EGA_CRTC, 0x11 ) & 0x7F );

	for ( int i = 0; i < sizeof ( CRTCTable ) / sizeof ( int ); i++ )
		outport ( EGA_CRTC, CRTCTable [i] );

						// clear screen
	WriteReg ( EGA_SEQUENCER, EGA_MAP_MASK, 0x0F );
	_fmemset ( MK_FP ( PageBase, 0 ), '\0', 0xFFFF );
}

void	SetX360x480 ()
{
	static int CRTCTable [] = {
		0x6b00,
		0x5901,
		0x5A02,
		0x8E03,
		0x5E04,
		0x8A05,
		0x0D06,  	// vertical total
		0x3E07,  	// overflow (bit 8 of vertical counts)
		0x4009,  	// cell height (2 to double-scan)
		0xEA10,  	// vert sync start
		0xAC11,  	// vert sync end and protect cr0-cr7
		0xDF12,  	// vertical displayed
		0x2D13,
		0x0014,  	// turn off dword mode
		0xE715,  	// vert blank start
		0x0616,  	// vert blank end
		0xE317  	// turn on byte mode
	};

	SetVideoMode ( 0x13 );

	PageBase     = 0xA000;
	BytesPerLine = 90;

	WriteReg ( EGA_SEQUENCER, 4, 6 );
	WriteReg ( EGA_CRTC, 0x17, 0xE3 );
	WriteReg ( EGA_CRTC, 0x14, 0 );

	WriteReg ( EGA_SEQUENCER, 0, 1 );	// synchronous reset
	outportb ( 0x3C2, 0xE7 );		// select 25 MHz dot clock
						// & 60 Hz scan rate
	WriteReg ( EGA_SEQUENCER, 0, 3 );	// restart sequencer
	WriteReg ( EGA_CRTC, 0x11, ReadReg ( EGA_CRTC, 0x11 ) & 0x7F );

	for ( int i = 0; i < sizeof ( CRTCTable ) / sizeof ( int ); i++ )
		outport ( EGA_CRTC, CRTCTable [i] );

						// clear screen
	WriteReg ( EGA_SEQUENCER, EGA_MAP_MASK, 0x0F );
	_fmemset ( MK_FP ( PageBase, 0 ), '\0', 0xFFFF );
}

void	SetVisualPage ( int page )
{
	unsigned addr = page * 0x4B00;

				// wait for vertical retrace
	while ( ( inportb ( 0x3DA ) & 0x08 ) == 0 )
		;

	WriteReg ( EGA_CRTC, 0x0C, addr >> 8 );
	WriteReg ( EGA_CRTC, 0xDC, addr & 0x0F );
}

void	SetActivePage ( int page )
{
	PageBase = 0xA000 + page * 0x4B0;
}

void	WritePixel ( int x, int y, int color )
{
	WriteReg ( EGA_SEQUENCER, EGA_MAP_MASK, 1 << ( x & 3 ) );

	pokeb ( PageBase, y * BytesPerLine + ( x >> 2 ), color );

	WriteReg ( EGA_SEQUENCER, EGA_MAP_MASK, 0x0F );
}

int	ReadPixel ( int x, int y )
{
	WriteReg ( EGA_GRAPHICS, EGA_READ_MAP_SELECT, x & 3 );

	return peekb ( PageBase, y * BytesPerLine + ( x >> 2 ) );
}

void	Bar ( int x1, int y1, int x2, int y2, int color )
{
	char far * vptr  = (char far *) MK_FP ( PageBase, y1 * BytesPerLine + (x1 >> 2) );
	char far * ptr   = vptr;
	int	   cols  = ( x2 >> 2 ) - ( x1 >> 2 ) - 1;
	char	   lmask = LeftPlaneMask [ x1 & 3 ];
	char	   rmask = RightPlaneMask [ x2 & 3 ];

	if ( cols < 0 )		// both x1 & x2 are located in the same byte
	{
		WriteReg ( EGA_SEQUENCER, EGA_MAP_MASK, lmask & rmask );

		for ( int y = y1; y <= y2; y++, vptr += BytesPerLine )
			*vptr = color;

		WriteReg ( EGA_SEQUENCER, EGA_MAP_MASK, 0x0F );
	}
	else
	{
		WriteReg ( EGA_SEQUENCER, EGA_MAP_MASK, lmask );

		for ( int y = y1; y <= y2; y++, vptr += BytesPerLine )
			*vptr = color;

		WriteReg ( EGA_SEQUENCER, EGA_MAP_MASK, 0x0F );

		vptr = ++ptr;

		for ( y = y1; y <= y2; y++, vptr += BytesPerLine - cols )
			for ( int x = 0; x < cols; x++ )
				*vptr++ = color;

		WriteReg ( EGA_SEQUENCER, EGA_MAP_MASK, rmask );

		vptr = ptr + cols;

		for ( y = y1; y <= y2; y++, vptr += BytesPerLine )
			*vptr = color;
	}

	WriteReg ( EGA_SEQUENCER, EGA_MAP_MASK, 0x0F );
}

void	DrawString ( int x, int y, char * str, int color )
{
	for ( ; *str != '\0'; str++, x+= 8 )
		for ( int j = 0; j < 16; j++ )
		{
			char	byte = Font [16 * (*str) + j];

			for ( int i = 0; i < 8; i++, byte <<= 1 )
				if ( byte & 0x80 )
					WritePixel ( x+i, y+j, color );
		}
}

void	Show360x480 ()
{
	RGB	Pal [256];

	SetX360x480 ();			// set 320x480 256 colors X-mode

	for ( int i = 0; i < 256; i++ )
	{
		int	c = i & 0x40 ? i & 0x3F : 0x3F - ( i & 0x3F );

		Pal [i].Red   = c;
		Pal [i].Green = c * c / 0x3F;
		Pal [i].Blue  = i & 0x80 ? 0x3F - ( i >> 1 ) & 0x3F : ( i >> 1 ) & 0x3F;
	}

	SetPalette ( Pal, 256 );

	for ( int x = 0; x < 180; x++ )
		for ( int y = 0; y < 240; y++ )
		{
			unsigned long	x2    = ( x + 1 ) * (long)( 360 - x );
			unsigned long	y2    = ( y + 1 ) * (long)( 480 - y );
			int	color = (int)((x2*x2)/y2/113);

			WritePixel ( x,       y,       color );
			WritePixel ( 359 - x, y,       color );
			WritePixel ( x,       479 - y, color );
			WritePixel ( 359 - x, 479 - y, color );
		}
}

main ()
{
	if ( !FindVGA () )
	{
		printf ( "\nVGA compatible card not found." );
		return -1;
	}

	SetX320x240 ();			// set 320x240 256 colors X-mode

	Font = FindROMFont ( 16 );

	for ( int j = 1; j < 220; j += 21 )
		for ( int i = 1; i < 300; i += 21 )
			Bar ( i, j, i + 20, j + 20, ( ( j / 21 * 15 ) + i / 21) & 0xFF );

	DrawString ( 110, 100, "Page 0", 70 );
	getch ();

	SetActivePage ( 1 );
	SetVisualPage ( 1 );
	Bar ( 10, 20, 300, 200, 33 );
	DrawString ( 110, 100, "Page 1", 75 );
	getch ();

	SetActivePage ( 2 );
	SetVisualPage ( 2 );
	Bar ( 10, 20, 300, 200, 39 );
	DrawString ( 110, 100, "Page 2", 80 );
	getch ();

	SetVisualPage ( 0 );
	getch ();
	SetVisualPage ( 1 );
	getch ();
	SetVisualPage ( 2 );
	getch ();

	Show360x480 ();

	getch ();
	SetVideoMode ( 3 );
}
