/////////////////////////////////////////////////////////
// Sample program to book                              //
//  Computer Graphics : Dynamics & Realistic Imaging.  //
//      by A.V. Boreskoff, E.V. Shikin                 //
//                                                     //
// Author:                                             //
//    Alex V. Boreskoff                                //
//                                                     //
// E-mail:                                             //
//    alex@garser.msk.su                               //
/////////////////////////////////////////////////////////

#include	<alloc.h>
#include	<conio.h>
#include	<mem.h>
#include	<stdio.h>
#include	"Ega.h"

unsigned   PageBase = 0;
char       LeftPlaneMask  [] = { 0x0F, 0x0E, 0x0C, 0x08 };
char	   RightPlaneMask [] = { 0x01, 0x03, 0x07, 0x0F };
char far * Font;

void	SetX ()
{
	SetVideoMode ( 0x13 );

	PageBase = 0xA000;

	WriteReg ( EGA_SEQUENCER, 4, 6 );
	WriteReg ( EGA_CRTC, 0x17, 0xE3 );
	WriteReg ( EGA_CRTC, 0x14, 0 );

				// clear screen
	WriteReg ( EGA_SEQUENCER, EGA_MAP_MASK, 0x0F );
	_fmemset ( MK_FP ( PageBase, 0 ), '\0', 0xFFFF );
}

void	SetVisualPage ( int page )
{
	unsigned addr = page * 0x4000;

				// wait for vertical retrace
	while ( ( inportb ( 0x3DA ) & 0x08 ) == 0 )
		;

	WriteReg ( EGA_CRTC, 0x0C, addr >> 8 );
	WriteReg ( EGA_CRTC, 0xDC, addr & 0x0F );
}

void	SetActivePage ( int page )
{
	PageBase = 0xA000 + page * 0x400;
}

void	WritePixel ( int x, int y, int color )
{
	WriteReg ( EGA_SEQUENCER, EGA_MAP_MASK, 1 << ( x & 3 ) );

	pokeb ( PageBase, y*80 + ( x >> 2 ), color );

	WriteReg ( EGA_SEQUENCER, EGA_MAP_MASK, 0x0F );
}

int	ReadPixel ( int x, int y )
{
	WriteReg ( EGA_GRAPHICS, EGA_READ_MAP_SELECT, x & 3 );

	return peekb ( PageBase, y*80 + ( x >> 2 ) );
}

void	Bar ( int x1, int y1, int x2, int y2, int color )
{
	char far * vptr  = (char far *) MK_FP ( PageBase, y1*80 + (x1 >> 2) );
	char far * ptr   = vptr;
	int	   cols  = ( x2 >> 2 ) - ( x1 >> 2 ) - 1;
	char	   lmask = LeftPlaneMask [ x1 & 3 ];
	char	   rmask = RightPlaneMask [ x2 & 3 ];

	if ( cols < 0 )		// both x1 & x2 are located in the same byte
	{
		WriteReg ( EGA_SEQUENCER, EGA_MAP_MASK, lmask & rmask );

		for ( int y = y1; y <= y2; y++, vptr += 80 )
			*vptr = color;

		WriteReg ( EGA_SEQUENCER, EGA_MAP_MASK, 0x0F );
	}
	else
	{
		WriteReg ( EGA_SEQUENCER, EGA_MAP_MASK, lmask );

		for ( int y = y1; y <= y2; y++, vptr += 80 )
			*vptr = color;

		WriteReg ( EGA_SEQUENCER, EGA_MAP_MASK, 0x0F );

		vptr = ++ptr;

		for ( y = y1; y <= y2; y++, vptr += 80 - cols )
			for ( int x = 0; x < cols; x++ )
				*vptr++ = color;

		WriteReg ( EGA_SEQUENCER, EGA_MAP_MASK, rmask );

		vptr = ptr + cols;

		for ( y = y1; y <= y2; y++, vptr += 80 )
			*vptr = color;
	}

	WriteReg ( EGA_SEQUENCER, EGA_MAP_MASK, 0x0F );
}

void	DrawString ( int x, int y, char * str, int color )
{
	for ( ; *str != '\0'; str++, x+= 8 )
		for ( int j = 0; j < 16; j++ )
		{
			char	byte = Font [16 * (*str) + j];

			for ( int i = 0; i < 8; i++, byte <<= 1 )
				if ( byte & 0x80 )
					WritePixel ( x+i, y+j, color );
		}
}

main ()
{
	if ( !FindVGA () )
	{
		printf ( "\nVGA compatible card not found." );
		return -1;
	}

	SetX ();			// set 320x200 256 colors X-mode

	Font = FindROMFont ( 16 );

	for ( int i = 0; i < 256; i++ )
		WritePixel ( i, 0, i );

	for ( i = 5; i < 140; i++ )
		Bar ( 2*i, i, 2*i+30, i+30, i );

	DrawString ( 110, 100, "Page 0", 70 );
	getch ();

	SetActivePage ( 1 );
	SetVisualPage ( 1 );
	Bar ( 10, 20, 300, 200, 33 );
	DrawString ( 110, 100, "Page 1", 75 );
	getch ();

	SetActivePage ( 2 );
	SetVisualPage ( 2 );
	Bar ( 10, 20, 300, 200, 39 );
	DrawString ( 110, 100, "Page 2", 80 );
	getch ();

	SetActivePage ( 3 );
	SetVisualPage ( 3 );
	Bar ( 10, 20, 300, 200, 44 );
	DrawString ( 110, 100, "Page 3", 85 );
	getch ();

	SetVisualPage ( 0 );
	getch ();
	SetVisualPage ( 1 );
	getch ();
	SetVisualPage ( 2 );
	getch ();

	SetVideoMode ( 3 );
}
