/////////////////////////////////////////////////////////
// Sample program to book                              //
//  Computer Graphics : Dynamics & Realistic Imaging.  //
//      by A.V. Boreskoff, E.V. Shikin                 //
//                                                     //
// Author:                                             //
//    Alex V. Boreskoff                                //
//                                                     //
// E-mail:                                             //
//    alex@garser.msk.su                               //
/////////////////////////////////////////////////////////

#include	<alloc.h>
#include	<conio.h>
#include	<stdio.h>
#include	"Ega.h"

int	ReadPixel ( int x, int y )
{
	int 	   color = 0;
	char far * vptr = (char far *) MK_FP ( 0xA000, y*80 + (x >> 3) );
	char	   mask = PixelMask ( x );

	for ( int plane = 3; plane >= 0; plane-- )
	{
		WriteReg ( EGA_GRAPHICS, EGA_READ_MAP_SELECT, plane );
		color <<= 1;
		if ( *vptr & mask )
			color |= 1;
	}

	return color;
}

void	WritePixel ( int x, int y, int color )
{
	char far * vptr = (char far *) MK_FP ( 0xA000, y*80 + (x >> 3) );

	WriteReg ( EGA_GRAPHICS, EGA_ENABLE_SET_RESET, 0x0F );	// enable all planes
	WriteReg ( EGA_GRAPHICS, EGA_SET_RESET, color );
	WriteReg ( EGA_GRAPHICS, EGA_BIT_MASK, PixelMask ( x ) );

	*vptr += 1;

	WriteReg ( EGA_GRAPHICS, EGA_ENABLE_SET_RESET, 0 );	// disable all planes
	WriteReg ( EGA_GRAPHICS, EGA_BIT_MASK, 0xFF );		// restore reg
}

int	FindPixel ( int x1, int x2, int y, int color )
{
	char far * vptr  = (char far *) MK_FP ( 0xA000, y*80 + (x1 >> 3) );
	int	   cols  = ( x2 >> 3 ) - ( x1 >> 3 ) - 1;
	char	   lmask = LeftMask ( x1 );
	char	   rmask = RightMask ( x2 );
	char	   mask;

	SetRWMode ( 1, 0 );
	WriteReg ( EGA_GRAPHICS, EGA_COLOR_COMPARE, color );

	if ( cols < 0 )
		return *vptr & lmask & rmask;

	if ( mask = *vptr++ & lmask )
		return mask;

	while ( cols-- > 0 )
		if ( mask = *vptr++ )
			return mask;

	return *vptr & rmask;
}

void	CopyRect ( int x1, int y1, int x2, int y2, int x, int y )
{
	char far * src  = (char far *) MK_FP ( 0xA000, y1*80 + (x1 >> 3) );
	char far * dst  = (char far *) MK_FP ( 0xA000, y*80 + (x >> 3) );
	int	   cols  = ( x2 >> 3 ) - ( x1 >> 3 );

	SetRWMode ( 0, 1 );

	for ( int i = y1; i <= y2; i++ )
	{
		for ( int j = 0; j < cols; j++ )
			*dst++ = *src++;

		src += 80 - cols;
		dst += 80 - cols;
	}

	SetRWMode ( 0, 0 );
}

void	Bar ( int x1, int y1, int x2, int y2, int color )
{
	char far * vptr  = (char far *) MK_FP ( 0xA000, y1*80 + (x1 >> 3) );
	int	   cols  = ( x2 >> 3 ) - ( x1 >> 3 ) - 1;
	char	   lmask = LeftMask ( x1 );
	char	   rmask = RightMask ( x2 );
	char	   latch;

	SetRWMode ( 0, 2 );

	if ( cols < 0 )		// both x1 & x2 are located in the same byte
	{
		WriteReg ( EGA_GRAPHICS, EGA_BIT_MASK, lmask & rmask );

		for ( int y = y1; y <= y2; y++, vptr += 80 )
		{
			latch = *vptr;
			*vptr = color;
		}

		WriteReg ( EGA_GRAPHICS, EGA_BIT_MASK, 0xFF );
	}
	else
	{
		for ( int y = y1; y <= y2; y++ )
		{
			WriteReg ( EGA_GRAPHICS, EGA_BIT_MASK, lmask );
			latch = *vptr;
			*vptr++ = color;

			WriteReg ( EGA_GRAPHICS, EGA_BIT_MASK, 0xFF );
			for ( int x = 0; x < cols; x++ )
			{
				latch = *vptr;
				*vptr++ = color;
			}

			WriteReg ( EGA_GRAPHICS, EGA_BIT_MASK, rmask );
			latch = *vptr;
			*vptr++ = color;

			vptr += 78 - cols;
		}
	}

	SetRWMode ( 0, 0 );
	WriteReg ( EGA_GRAPHICS, EGA_BIT_MASK, 0xFF );
}

void	StoreRect ( int x1, int y1, int x2, int y2, char huge * buf )
{
	char far * vptr  = (char far *) MK_FP ( 0xA000, y1*80 + (x1 >> 3) );
	int	   cols  = ( x2 >> 3 ) - ( x1 >> 3 ) - 1;

	if ( cols < 0 )
		cols = 0;

	for ( int y = y1; y <= y2; y++, vptr += 80 )
		for ( int plane = 0; plane < 4; plane++ )
		{
			WriteReg ( EGA_GRAPHICS, EGA_READ_MAP_SELECT, plane );

			for ( int x = 0; x < cols + 2; x++ )
				*buf++ = *vptr++;

			vptr -= cols + 2;
		}
}

void	RestoreRect ( int x1, int y1, int x2, int y2, char huge * buf )
{
	char far * vptr  = (char far *) MK_FP ( 0xA000, y1*80 + (x1 >> 3) );
	int	   cols  = ( x2 >> 3 ) - ( x1 >> 3 ) - 1;
	char	   lmask = LeftMask ( x1 );
	char	   rmask = RightMask ( x2 );
	char	   latch;

	if ( cols < 0 )
	{
		lmask &= rmask;
		rmask  = 0;
		cols   = 0;
	}

	for ( int y = y1; y <= y2; y++, vptr += 80 )
		for ( int plane = 0; plane < 4; plane++ )
		{
			WriteReg ( EGA_GRAPHICS,  EGA_BIT_MASK, lmask );
			WriteReg ( EGA_SEQUENCER, EGA_MAP_MASK, 1 << plane );

			latch = *vptr;
			*vptr++ = *buf++;

			WriteReg ( EGA_GRAPHICS, EGA_BIT_MASK, 0xFF );

			for ( int x = 0; x < cols; x++ )
				*vptr++ = *buf++;

			WriteReg ( EGA_GRAPHICS,  EGA_BIT_MASK, rmask );

			latch = *vptr;
			*vptr++ = *buf++;

			vptr -= cols + 2;
		}

		WriteReg ( EGA_GRAPHICS,  EGA_BIT_MASK, 0xFF );
		WriteReg ( EGA_SEQUENCER, EGA_MAP_MASK, 0x0F );
}

main ()
{
	if ( !FindEGA () )
	{
		printf ( "\nEGA compatible card not found." );
		return -1;
	}

	SetVideoMode ( 0x10 );		// set 640x350 16 colors mode

	for ( int i = 0; i < 128; i++ )
		WritePixel ( i, 0, ( i >> 2 ) & 0x0F );

	SetWriteMode ( 3 );			// set XOR write mode

	for ( i = 1; i < 200; i += 10 )
		Bar ( i, i, i + 45, i + 55, i & 0x0F );

	SetWriteMode ( 0 );

	char huge * buf = (char huge *)farmalloc ( 60000U );

	StoreRect ( 0, 0, 100, 100, buf );
	getch ();
	RestoreRect ( 240, 20, 340, 120, buf );
	getch ();
	farfree ( buf );

	Bar ( 500, 200, 600, 300, MAGENTA );
	Bar ( 400, 100, 500, 150, YELLOW );

	getch ();
	SetVideoMode ( 3 );
}
