/////////////////////////////////////////////////////////
// Sample program to book                              //
//  Computer Graphics : Dynamics & Realistic Imaging.  //
//      by A.V. Boreskoff, E.V. Shikin                 //
//                                                     //
// Author:                                             //
//    Alex V. Boreskoff                                //
//                                                     //
// E-mail:                                             //
//    alex@garser.msk.su                               //
/////////////////////////////////////////////////////////

#include	<dos.h>
#include	"Ega.h"

int	FindEGA ()
{
	asm {
		mov	ax, 1200h
		mov	bx, 10h
		int	10h
	}

	return _BL != 0x10;
}

int	FindVGA ()
{
	asm {
		mov	ax, 1A00h
		int	10h
	}

	return _AL == 0x1A;
}

void	SetVideoMode ( int mode )
{
	asm {
		mov	ax, mode
		int	10h
	}
}

void	SetVisiblePage ( int page )
{
	asm {
		mov	ah, 5
		mov	al, byte ptr page
		int	10h
	}
}

char far * FindROMFont ( int size )
{
	int	b = ( size == 16 ? 6 : 2 );

	asm {
		push	es
		push	bp
		mov	ax, 1130h
		mov	bh, byte ptr b
		mov	bl, 0
		int	10h
		mov	ax, es
		mov	bx, bp
		pop	bp
		pop	es
	}

	return (char far *) MK_FP ( _AX, _BX );
}

void	SetPalette ( RGB far * Palette, int size )
{
	asm {
		push	es
		mov	ax, 1012h
		mov	bx, 0			// first color to set
		mov	cx, size		// # of colors
		les	dx, Palette		// ES:DX == table of color values
		int	10h
		pop	es
	}
}
