/////////////////////////////////////////////////////////
// Sample program to book                              //
//  Computer Graphics : Dynamics & Realistic Imaging.  //
//      by A.V. Boreskoff, E.V. Shikin                 //
//                                                     //
// Author:                                             //
//    Alex V. Boreskoff                                //
//                                                     //
// E-mail:                                             //
//    alex@garser.msk.su                               //
/////////////////////////////////////////////////////////

#ifndef	__VESA__
#define	__VESA__
					// 256-color modes
#define	VESA_640x400x256	0x100
#define	VESA_640x480x256	0x101
#define	VESA_800x600x256	0x103
#define	VESA_1024x768x256	0x105
#define	VESA_1280x1024x256	0x107
					// 32K color modes
#define	VESA_320x200x32K	0x10D
#define	VESA_640x480x32K	0x110
#define	VESA_800x600x32K	0x113
#define	VESA_1024x768x32K	0x116
#define	VESA_1280x1024x32K	0x119
					// 64K color modes
#define	VESA_320x200x64K	0x10E
#define	VESA_640x480x64K	0x111
#define	VESA_800x600x64K	0x114
#define	VESA_1024x768x64K	0x117
#define	VESA_1280x1024x64K	0x11A
					// 16M color mode
#define	VESA_320x200x16M	0x10F
#define	VESA_640x480x16M	0x112
#define	VESA_800x600x16M	0x115
#define	VESA_1024x768x16M	0x118
#define	VESA_1280x1024x16M 	0x11B

struct	VESAInfo
{
	char	   Sign [4];	// 'VESA' signature
	int	   Version;	// VESA BIOS version
	char far * OEM;		// Original Equipment Manufactureer string
	long	   Capabilities;
	int far  * ModeList;	// list of supported modes
	int	   TotalMemory;	// total memory on board in 64Kb blocks
	char	   Reserved [236];
};

struct	VESAModeInfo
{
	int	   ModeAttributes;
	char	   WinAAttributes;
	char	   WinBAttributes;
	int	   WinGranularity;
	int	   WinSize;
	unsigned   WinASegment;
	unsigned   WinBSegement;
	void far * WinFuncPtr;
	int	   BytesPerScanLine;
				// optional data
	int	   XResolution;
	int	   YResolution;
	char	   XCharSize;
	char	   YCharSize;
	char	   NumberOfPlanes;
	char	   BitsPerPixel;
	char	   NumberOfBanks;
	char	   MemoryModel;
	char	   BankSize;
	char	   NumberOfPages;
	char	   Reserved;
				// direct color fields
	char	   RedMaskSize;
	char	   RedFieldPosition;
	char	   GreenMaskSize;
	char	   GreenFieldPosition;
	char	   BlueMaskSize;
	char	   BlueFieldPosition;
	char	   RsvdMaskSize;
	char	   RsvdFieldPosition;
	char	   DirectColorModeInfo;
	char	   Resererved2 [216];
};

int	FindVESA ( VESAInfo& );
int	FindVESAMode ( int, VESAModeInfo& );
int	SetVESAMode ( int );
int	GetVESAMode ();
void	SetVESABank ();
#endif
