/////////////////////////////////////////////////////////
// Sample program to book                              //
//  Computer Graphics : Dynamics & Realistic Imaging.  //
//      by A.V. Boreskoff, E.V. Shikin                 //
//                                                     //
// Author:                                             //
//    Alex V. Boreskoff                                //
//                                                     //
// E-mail:                                             //
//    alex@garser.msk.su                               //
/////////////////////////////////////////////////////////

// test for Realtec cards
#include	<conio.h>
#include	<dos.h>
#include	<process.h>
#include	<stdio.h>

#define LOWORD(l)           ((int)(l))
#define HIWORD(l)           ((int)((l) >> 16))

static	int	CurBank = 0;

void	SetRealtecMode ( int mode )
{
	asm {
		mov	ax, mode
		int	10h
	}
}

void	SetRealtecBank ( int start )
{
	if ( start == CurBank )
		return;

	CurBank = start;
	asm {
		mov	ax, start
		and	al, 0Fh
		mov	dx, 3D7h
		out	dx, al
	}
}

void	WritePixel ( int x, int y, int color )
{
	long	addr = 640l * (long)y + (long)x;

	SetRealtecBank ( HIWORD ( addr ) );
	pokeb ( 0xA000, LOWORD ( addr ), color );
}

main ()
{
	SetRealtecMode ( 0x26 );	// 640x480x256

	for ( int i = 0; i < 640; i++ )
		for ( int j = 0; j < 480; j++ )
			WritePixel ( i, j, ((i/20)+1)*(j/20+1) );

	getch ();
}
