/////////////////////////////////////////////////////////
// Sample program to book                              //
//  Computer Graphics : Dynamics & Realistic Imaging.  //
//      by A.V. Boreskoff, E.V. Shikin                 //
//                                                     //
// Author:                                             //
//    Alex V. Boreskoff                                //
//                                                     //
// E-mail:                                             //
//    alex@garser.msk.su                               //
/////////////////////////////////////////////////////////

// test for Oak cards
#include	<conio.h>
#include	<dos.h>
#include	<process.h>
#include	<stdio.h>

#define	OAK_037C	1
#define	OAK_067		2
#define	OAK_077		3

#define LOWORD(l)           ((int)(l))
#define HIWORD(l)           ((int)((l) >> 16))

inline	void	WriteReg ( int base, int reg, int value )
{
	outportb ( base,     reg );
	outportb ( base + 1, value );
}

inline	char	ReadReg ( int base, int reg )
{
	outportb ( base, reg );

	return inportb ( base + 1 );
}

static	int	CurBank = 0;

// check bits specified by mask in port for being readable/writable
int	TestPort ( int port, char mask )
{
	char	save = inportb ( port );

	outportb ( port, save & ~mask );

	char	v1 = inportb ( port ) & mask;

	outportb ( port, save | mask );

	char	v2 = inportb ( port ) & mask;

	outportb ( port, save );

	return v1 == 0 && v2 == mask;
}

int	TestReg ( int port, int reg, char mask )
{
	outportb ( port, reg );

	return TestPort ( port + 1, mask );
}

int	FindOak ()
{
	if ( !TestReg ( 0x3DE, 0x0D, 0x38 ) )
		return 0;

	if ( !TestReg ( 0x3DE, 0x11, 0xFF ) )	// OTI-037C bank switching registers are read only We have an Oak Technologies SuperVGA, so determine the type. The OTI-037C
		return OAK_037C;

	if ( ( ReadReg ( 0x3DE, 0x0B ) >> 5 ) == 5 )
		return OAK_077;
	else
		return OAK_067;
}

void	SetOakMode ( int mode )
{
	asm {
		mov	ax, mode
		int	10h
	}
}

void	SetOakBank ( int start )
{
	if ( start == CurBank )
		return;

	CurBank = start;
	asm {
		mov	dx, 3CEh
		mov	ax, start
		and	al, 0Fh
		mov	ah, al
		mov	cl, 4
		shl	al, cl
		or	ah, al
		mov	al, 11h
		out	dx, ax
	}
}

void	WritePixel ( int x, int y, int color )
{
	long	addr = 640l * (long)y + (long)x;

	SetOakBank ( HIWORD ( addr ) );
	pokeb ( 0xA000, LOWORD ( addr ), color );
}

main ()
{
	if ( !FindOak () )
	{
		printf ( "\nOak card not found" );
		exit ( 1 );
	}

	SetOakMode ( 0x53 );	// 640x480x256

	for ( int i = 0; i < 640; i++ )
		for ( int j = 0; j < 480; j++ )
			WritePixel ( i, j, ((i/20)+1)*(j/20+1) );

	getch ();
}
