/////////////////////////////////////////////////////////
// Sample program to book                              //
//  Computer Graphics : Dynamics & Realistic Imaging.  //
//      by A.V. Boreskoff, E.V. Shikin                 //
//                                                     //
// Author:                                             //
//    Alex V. Boreskoff                                //
//                                                     //
// E-mail:                                             //
//    alex@garser.msk.su                               //
/////////////////////////////////////////////////////////

// test for VESA
#include	<conio.h>
#include	<dos.h>
#include	<process.h>
#include	<stdio.h>
#include	<string.h>
#include	"Vesa.h"

int	FindVESA ( VESAInfo& vi )
{
#if defined(__COMPACT__) || defined(__LARGE__) || defined(__HUGE__)
	asm {
		push	es
		push	di
		les	di, dword ptr vi
		mov	ax, 4F00h
		int	10h
		pop	di
		pop	es
	}
#else
	asm {
		push	di
		mov	di, word ptr vi
		mov	ax, 4F00h
		int	10h
		pop	di
	}
#endif
	if ( _AX != 0x004F )
		return 0;

	return !strncmp ( vi.Sign, "VESA", 4 );
}

int	FindVESAMode ( int mode, VESAModeInfo& mi )
{
#if defined(__COMPACT__) || defined(__LARGE__) || defined(__HUGE__)
	asm {
		push	es
		push	di
		les	di, dword ptr mi
		mov	ax, 4F01h
		mov	cx, mode
		int	10h
		pop	di
		pop	es
	}
#else
	asm {
		push	di
		mov	di, word ptr mi
		mov	ax, 4F01h
		mov	cx, mode
		int	10h
		pop	di
	}
#endif
	return _AX == 0x004F;

}

char * ColorInfo ( int bits )
{
	switch ( bits )
	{
		case 4:
			return "16 colors";

		case 8:
			return "256 colors";

		case 15:
			return "32K colors ( HiColor )";

		case 16:
			return "64K colors ( HiColor )";

		case 24:
			return "16M colors ( TrueColor )";

		default:
			return "";
	}
}

void	DumpMode ( int mode )
{
	VESAModeInfo mi;

	if ( !FindVESAMode ( mode, mi ) )
		return;

	if ( ( mi.ModeAttributes & 1 ) == 0 )	// not available now
		return;

	printf ( "\n%4X %10s %4dx%4d %2d %s", mode,
			mi.ModeAttributes & 0x10 ? "Graphics" : "Text",
			mi.XResolution, mi.YResolution, mi.BitsPerPixel,
			ColorInfo ( mi.BitsPerPixel ) );
}

main ()
{
	VESAInfo Info;
	char	 str [256];

	if ( !FindVESA ( Info ) )
	{
		printf ( "VESA VBE not found" );
		exit ( 1 );
	}

        _fstrcpy ( str, Info.OEM );
	printf ( "\nVESA VBE version %d.%d\nOEM: %s\nTotal memory: %dKb\n",
		 Info.Version >> 8, Info.Version & 0xFF, str, Info.TotalMemory * 64 );

	for ( int i = 0; Info.ModeList [i] != -1; i++ )
		DumpMode ( Info.ModeList [i] );
}
