/////////////////////////////////////////////////////////
// Sample program to book                              //
//  Computer Graphics : Dynamics & Realistic Imaging.  //
//      by A.V. Boreskoff, E.V. Shikin                 //
//                                                     //
// Author:                                             //
//    Alex V. Boreskoff                                //
//                                                     //
// E-mail:                                             //
//    alex@garser.msk.su                               //
/////////////////////////////////////////////////////////

// test for VESA
#include	<conio.h>
#include	<dos.h>
#include	<process.h>
#include	<stdio.h>
#include	<string.h>
#include	"Vesa.h"

#define LOWORD(l)           ((int)(l))
#define HIWORD(l)           ((int)((l) >> 16))

static	int		CurBank     = 0;
static	int		Granularity = 1;
static	VESAModeInfo	CurMode;

int	FindVESA ( VESAInfo& vi )
{
#if defined(__COMPACT__) || defined(__LARGE__) || defined(__HUGE__)
	asm {
		push	es
		push	di
		les	di, dword ptr vi
		mov	ax, 4F00h
		int	10h
		pop	di
		pop	es
	}
#else
	asm {
		push	di
		mov	di, word ptr vi
		mov	ax, 4F00h
		int	10h
		pop	di
	}
#endif
	if ( _AX != 0x004F )
		return 0;

	return !strncmp ( vi.Sign, "VESA", 4 );
}

int	FindVESAMode ( int mode, VESAModeInfo& mi )
{
#if defined(__COMPACT__) || defined(__LARGE__) || defined(__HUGE__)
	asm {
		push	es
		push	di
		les	di, dword ptr mi
		mov	ax, 4F01h
		mov	cx, mode
		int	10h
		pop	di
		pop	es
	}
#else
	asm {
		push	di
		mov	di, word ptr mi
		mov	ax, 4F01h
		mov	cx, mode
		int	10h
		pop	di
	}
#endif
	return _AX == 0x004F;

}

int	SetVESAMode ( int mode )
{
	if ( !FindVESAMode ( mode, CurMode ) )
		return 0;

	Granularity = 64 / CurMode.WinGranularity;
	asm {
		mov	ax, 4F02h
		mov	bx, mode
		int	10h
	}

	return _AX == 0x004F;
}

int	GetVESAMode ()
{
	asm {
		mov	ax, 4F03h
		int	10h
	}

	if ( _AX != 0x004F )
		return 0;
	else
		return _BX;
}

void	SetVESABank ( int start )
{
	if ( start == CurBank )
		return;

	CurBank = start;
	start  *= Granularity;
	asm {
		mov	ax, 4F05h
		mov	bx, 0
		mov	dx, start
		push	dx
		int	10h
		mov	bx, 1
		pop	dx
		int	10h
	}
}

void	WritePixel ( int x, int y, int color )
{
	long	addr = (long)CurMode.BytesPerScanLine * (long)y + (long)x;

	SetVESABank ( HIWORD ( addr ) );
	pokeb ( 0xA000, LOWORD ( addr ), color );
}

main ()
{
	VESAInfo  vi;

	if ( !FindVESA ( vi ) )
	{
		printf ( "\nVESA VBE not found." );
		exit ( 1 );
	}

	if ( !SetVESAMode ( VESA_640x480x256 ) )
		exit ( 1 );

	for ( int i = 0; i < 640; i++ )
		for ( int j = 0; j < 480; j++ )
			WritePixel ( i, j, ((i/20)+1)*(j/20+1) );

	getch ();
}
