/////////////////////////////////////////////////////////
// Sample program to book                              //
//  Computer Graphics : Dynamics & Realistic Imaging.  //
//      by A.V. Boreskoff, E.V. Shikin                 //
//                                                     //
// Author:                                             //
//    Alex V. Boreskoff                                //
//                                                     //
// E-mail:                                             //
//    alex@garser.msk.su                               //
/////////////////////////////////////////////////////////

#include	<bios.h>
#include	<conio.h>
#include	<graphics.h>
#include	<process.h>
#include	<stdio.h>

int	Port = 0;		// use LPT1:

inline	int	Print ( char byte )
{
	return biosprint ( 0, byte, Port );
}

int	PrintStr ( char * str )
{
	int	st;

	while ( *str != '\0' )
		if ( ( st = Print ( *str++ ) ) & 1 )
			return st;

	return 0;
}

void	PrintScreenLJ ( int x1, int y1, int x2, int y2 )
{
	int	NumCols   = x2 - x1 + 1;
	int	Byte;
	char	str [20];

	PrintStr ( "\x1B*t150R" );		// set density 150 dpi
	PrintStr ( "\x1B&a5C" );		// move cursor to col 5
	PrintStr ( "\x1B*r1A" );		// begin raster graphics

	sprintf ( str, "\x1B*b%dW", (NumCols+7)>>3);	// prepare line header

	for ( int y = y1; y <= y2; y++ )
	{
		PrintStr ( str );

		for ( int x = x1; x <= x2; )
		{
			Byte = 0;
			for ( int i = 0; i < 8 && x <= x2; i++, x++ )
				if ( getpixel ( x, y ) > 0 )
					Byte |= 0x80 >> i;

			Print ( Byte );
		}
	}

	PrintStr ( "\x1B*rB" );
}

main ()
{
	int	driver = DETECT;
	int	mode;
	int	res;

	initgraph ( &driver, &mode, "" );
	if ( ( res = graphresult () ) != grOk )
	{
		printf("\nGraphics error: %s\n", grapherrormsg ( res) );
		exit ( 1 );
	}

	line ( 0, 0, 0, getmaxy () );
	line ( 0, getmaxy (), getmaxx (), getmaxy () );
	line ( getmaxx (), getmaxy (), getmaxx (), 0 );
	line ( getmaxx (), 0, 0, 0 );

	for ( int i = TRIPLEX_FONT; i <= GOTHIC_FONT; i++ )
	{
		settextstyle ( i, HORIZ_DIR, 5 );
		outtextxy ( 100, 50*i, "Some string" );
	}

	getch ();

	PrintScreenLJ ( 0, 0, getmaxx (), getmaxy () );

	closegraph ();
}
