/////////////////////////////////////////////////////////
// Sample program to book                              //
//  Computer Graphics : Dynamics & Realistic Imaging.  //
//      by A.V. Boreskoff, E.V. Shikin                 //
//                                                     //
// Author:                                             //
//    Alex V. Boreskoff                                //
//                                                     //
// E-mail:                                             //
//    alex@garser.msk.su                               //
/////////////////////////////////////////////////////////

#include	<bios.h>
#include	<conio.h>
#include	<graphics.h>
#include	<process.h>
#include	<stdio.h>

int	Port = 0;		// use LPT1:

inline	int	Print ( char byte )
{
	return biosprint ( 0, byte, Port );
}

void	PrintScreenFX ( int x1, int y1, int x2, int y2 )
{
	int	NumPasses = ( y2 >> 3 ) - ( y1 >> 3 ) + 1;
	int	NumCols   = x2 - x1 + 1;
	int	Byte;

	Print ( '\r' );
	for ( int pass = 0, y = y1; pass < NumPasses; pass++, y += 8 )
	{
		Print ( '\x1B ');
		Print ( 'L' );
		Print ( NumCols & 0xFF );
		Print ( NumCols >> 8 );

		for ( int x = x1; x <= x2; x++ )
		{
			Byte = 0;
			for ( int i = 0; i < 8 && y + i <= y2; i++ )
				if ( getpixel ( x, y + i ) > 0 )
					Byte |= 0x80 >> i;

			Print ( Byte );
		}

		Print ( '\x1B' );
		Print ( 'J' );
		Print ( 24 );
		Print ( '\r' );
	}
}

main ()
{
	int	driver = DETECT;
	int	mode;
	int	res;

	initgraph ( &driver, &mode, "" );
	if ( ( res = graphresult () ) != grOk )
	{
		printf("\nGraphics error: %s\n", grapherrormsg ( res) );
		exit ( 1 );
	}

	line ( 0, 0, 0, getmaxy () );
	line ( 0, getmaxy (), getmaxx (), getmaxy () );
	line ( getmaxx (), getmaxy (), getmaxx (), 0 );
	line ( getmaxx (), 0, 0, 0 );

	for ( int i = TRIPLEX_FONT; i <= GOTHIC_FONT; i++ )
	{
		settextstyle ( i, HORIZ_DIR, 5 );
		outtextxy ( 100, 50*i, "Some string" );
	}

	getch ();

	PrintScreenFX ( 0, 0, getmaxx (), getmaxy () );

	closegraph ();
}
