/////////////////////////////////////////////////////////
// Sample program to book                              //
//  Computer Graphics : Dynamics & Realistic Imaging.  //
//      by A.V. Boreskoff, E.V. Shikin                 //
//                                                     //
// Author:                                             //
//    Alex V. Boreskoff                                //
//                                                     //
// E-mail:                                             //
//    alex@garser.msk.su                               //
/////////////////////////////////////////////////////////

#ifndef	__MOUSE__
#define	__MOUSE__

#define	MOUSE_MOVE_MASK		0x01
#define	MOUSE_LBUTTON_PRESS	0x02
#define	MOUSE_LBUTTON_RELEASE	0x04
#define	MOUSE_RBUTTON_PRESS	0x08
#define	MOUSE_RBUTTON_RELEASE	0x10
#define	MOUSE_MBUTTON_PRESS	0x20
#define	MOUSE_MBUTTON_RELEASE	0x40
#define	MOUSE_ALL_EVENTS	0x7F

struct	MouseState
{
	int	x, y;
	int	Buttons;
};

struct	CursorShape
{
	unsigned AndMask [16];
	unsigned XorMask [16];
	int	 HotX, HotY;
};

typedef	void	( *MouseHandler )( int, int, int, int );

int	ResetMouse ();
void	ShowMouseCursor ();
void	HideMouseCursor ();
void	ReadMouseState ( MouseState& );
void	MoveMouseCursor ( int, int );
void	SetMouseHorzRange ( int, int );
void	SetmouseVertRange ( int, int );
void	SetMouseShape ( CursorShape& );
void    SetHideRange ( int, int, int, int );
void	SetMouseHandler ( MouseHandler, int = MOUSE_ALL_EVENTS );
void	RemoveMouseHandler ();

#define	ClearHideRange ()	ShowMouseCursor ()
#endif
