/////////////////////////////////////////////////////////
// Sample program to book                              //
//  Computer Graphics : Dynamics & Realistic Imaging.  //
//      by A.V. Boreskoff, E.V. Shikin                 //
//                                                     //
// Author:                                             //
//    Alex V. Boreskoff                                //
//                                                     //
// E-mail:                                             //
//    alex@garser.msk.su                               //
/////////////////////////////////////////////////////////

#include	<alloc.h>
#include	"Mouse.h"

#pragma inline

static	MouseHandler	CurHandler = NULL;

int	ResetMouse ()
{
	asm {
		xor	ax, ax
		int	33h
	}

	return _AX == 0xFFFF;
}

void	ShowMouseCursor ()
{
	asm {
		mov	ax, 1
		int	33h
	}
}

void	HideMouseCursor ()
{
	asm {
		mov	ax, 2
		int	33h
	}
}

void	ReadMouseState ( MouseState& s )
{
	asm {
		mov	ax, 3
		int	33h
	}

#if defined(__COMPACT__) || defined(__LARGE__) || defined(__HUGE__)
	asm {
		push	es
		push	di
		les	di, dword ptr s
		mov	es:[di  ], cx
		mov	es:[di+2], dx
		mov	es:[di+4], bx
		pop	di
		pop	es
	}
#else
	asm {
		push	di
		mov	di, word ptr s
		mov	[di  ], cx
		mov	[di+2], dx
		mov	[di+4], bx
		pop	di
	}
#endif
}

void	MoveMouseCursor ( int x, int y )
{
	asm {
		mov	ax, 4
		mov	cx, x
		mov	dx, y
		int	33h
	}
}

void	SetHorzMouseRange ( int xmin, int xmax )
{
	asm {
		mov	ax, 7
		mov	cx, xmin
		mov	dx, xmax
		int	33h
	}
}

void	SetVertMouseRange ( int ymin, int ymax )
{
	asm {
		mov	ax, 8
		mov	cx, ymin
		mov	dx, ymax
		int	33h
	}
}

void	SetMouseShape ( CursorShape& c )
{
#if defined(__COMPACT__) || defined(__LARGE__) || defined(__HUGE__)
	asm {
		push	es
		push	di
		les	di, dword ptr c
		mov	bx, es:[di+16]
		mov	cx, es:[di+18]
		mov	dx, di
		mov	ax, 9
		int	33h
		pop	di
		pop	es
	}
#else
	asm {
		push	di
		mov	di, word ptr c
		mov	bx, [di+16]
		mov	cx, [di+18]
		mov	dx, di
		mov	ax, 9
		int	33h
		pop	di
	}
#endif
}

void    SetHideRange ( int x1, int y1, int x2, int y2 )
{
	asm {
		push	si
		push	di
		mov	ax, 10h
		mov	cx, x1
		mov	dx, y1
		mov	si, x2
		mov	di, y2
		int	33h
		pop	di
		pop	si
	}
}

static void far MouseStub ()
{
	asm {
		push	ds	// preserve ds
		push	ax	// preserve ax
		mov	ax, seg CurHandler
		mov	ds, ax
		pop	ax	// restore ax
		push	dx	// y
		push	cx	// x
		push	bx	// button state
		push	ax	// event mask
		call	CurHandler
		add	sp, 8	// clear stack
		pop	ds
	}
}

void	SetMouseHandler ( MouseHandler h, int mask )
{
	void	far * p = MouseStub;

	CurHandler = h;

	asm {
		push	es
		mov	ax, 0Ch
		mov	cx, mask
		les	dx, p
		int	33h
		pop	es
	}
}

void	RemoveMouseHandler ()
{
	CurHandler = NULL;

	asm {
		mov	ax, 0Ch
		mov	cx, 0
		int	33h
	}
}
