/////////////////////////////////////////////////////////
// Sample program to book                              //
//  Computer Graphics : Dynamics & Realistic Imaging.  //
//      by A.V. Boreskoff, E.V. Shikin                 //
//                                                     //
// Author:                                             //
//    Alex V. Boreskoff                                //
//                                                     //
// E-mail:                                             //
//    alex@garser.msk.su                               //
/////////////////////////////////////////////////////////

#include	<bios.h>
#include	<conio.h>
#include	"Mouse.h"

CursorShape c = {
	0x0FFF,
	0x07FF,
	0x01FF,
	0x007F,
	0x801F,
	0xC007,
	0xC001,
	0xE000,
	0xE0FF,
	0xF0FF,
	0xF0FF,
	0xF8FF,
	0xF8FF,
	0xFCFF,
	0xFCFF,
	0xFEFF,
	0x0000,
	0x6000,
	0x7800,
	0x3E00,
	0x3F80,
	0x1FE0,
	0x1FF8,
	0x0FFE,
	0x0F00,
	0x0700,
	0x0700,
	0x0300,
	0x0300,
	0x0100,
	0x0100,
	0x0000,
	1, 1
};

int	DoneFlag = 0;

void	SetVideoMode ( int mode )
{
	asm {
		mov	ax, mode
		int	10h
	}
}

#pragma argsused
void	WaitPress ( int mask, int button, int x, int y )
{
	if ( mask & MOUSE_RBUTTON_PRESS )
		DoneFlag = 1;
}

main ()
{
	SetVideoMode ( 0x12 );
	ResetMouse ();
	ShowMouseCursor ();
	SetMouseShape ( c );
	SetMouseHandler ( WaitPress );
	MoveMouseCursor ( 0, 0 );

	while ( !DoneFlag )
		;

	HideMouseCursor ();
	RemoveMouseHandler ();
	SetVideoMode ( 3 );
}
