// StarSystem.h
//

#ifndef __StarSystem_h__
#define __StarSystem_h__

#include "Star.h"
#include "Planet.h"

class CStarSystem : public CStar
{
protected:
	int m_nPlanets;
	CPlanet *m_pPlanets;
	CPtrList m_llPlanets;

public:
	CStarSystem()
	{
		m_pPlanets = NULL;
	}
	CStarSystem(CInfo &info)
	{
		m_pPlanets = NULL;
		Init(info);
	}
	~CStarSystem()
	{
		Cleanup();
	}

	bool Init(CInfo &info);
	void Cleanup();
	void Update(C3DObject *pCamera, float fSeconds, int nPolygonMode, float fMaxError, bool bUpdate, bool bTexture);
	void Draw(C3DObject *pCamera, float fSeconds, int nPolygonMode, float fMaxError, bool bUpdate, bool bTexture);

	int GetPlanetCount()		{ return m_nPlanets; }
	CPlanet *GetPlanet(int i)	{ return &m_pPlanets[i]; }
	CPtrListNode *GetHeadPlanet()	{ return m_llPlanets.GetHead(); }
	CPtrListNode *GetTailPlanet()	{ return m_llPlanets.GetTail(); }
};

#endif // __StarSystem_h__
