// Star.cpp
//

#include "Master.h"
#include "Star.h"

void CStar::Init(CInfo &info)
{
	strcpy(m_szName, info.GetTextValue("Name"));
	m_fRadius = info.GetFloatValue("Radius") * 0.1f;
	m_fStrength = info.GetFloatValue("Strength");
	m_cColor = info.GetColorValue("Color");
	SetPosition(CDoubleVector(0, 0, 0));
}

void CStar::Draw(C3DObject *pCamera)
{
	glEnable(GL_BLEND);
	glBlendFunc(GL_ONE, GL_ONE);
	CTexture::GetStar().Enable();
	CMatrix m;
	GetScaledBillboardMatrix(m, pCamera, m_fRadius*50);
	glPushMatrix();
	glMultMatrixf(m);

	CVector v;
	glColor4ubv(m_cColor);
	glBegin(GL_TRIANGLE_STRIP);
	v = CVector(1, 1, 0);
	glTexCoord2f(1.0, 1.0);
	glVertex3fv(v);
	v = CVector(-1, 1, 0);
	glTexCoord2f(0.0, 1.0);
	glVertex3fv(v);
	v = CVector(1, -1, 0);
	glTexCoord2f(1.0, 0.0);
	glVertex3fv(v);
	v = CVector(-1, -1, 0);
	glTexCoord2f(0.0, 0.0);
	glVertex3fv(v);
	glEnd();
	glPopMatrix();
	CTexture::GetStar().Disable();
	glDisable(GL_BLEND);
}
