// PlanetInfo.h
//

#ifndef __PlanetInfo_h__
#define __PlanetInfo_h__

#include "Matrix.h"

class CInfo
{
protected:
	char m_szFile[_MAX_PATH];
	char m_szKey[_MAX_PATH];

public:
	CInfo()
	{
	}
	CInfo(const char *pszFile, const char *pszKey)
	{
		Init(pszFile, pszKey);
	}
	CInfo(const CInfo &info, const char *pszKey)
	{
		Init(info, pszKey);
	}
	~CInfo()
	{
		Cleanup();
	}

	void Init(const char *pszFile, const char *pszKey)
	{
		strcpy(m_szFile, pszFile);
		strcpy(m_szKey, pszKey);
	}
	void Init(const CInfo &info, const char *pszKey)
	{
		strcpy(m_szFile, info.m_szFile);
		strcpy(m_szKey, pszKey);
	}
	void Cleanup()
	{
		// Stub for future cleanup code
	}

	const char *GetFile()			{ return m_szFile; }
	const char *GetKey()			{ return m_szKey; }

	const char *GetTextValue(const char *pszValue, const char *pszDefault="")
	{
		const char *psz = pszDefault;
		static char szTemp[_MAX_PATH];
		GetPrivateProfileString(m_szKey, pszValue, "", szTemp, _MAX_PATH, m_szFile);
		if(*szTemp)
			psz = szTemp;
		return psz;
	}
	int GetIntValue(const char *pszValue, int nDefault=0)
	{
		int nValue = nDefault;
		char szTemp[_MAX_PATH];
		GetPrivateProfileString(m_szKey, pszValue, "", szTemp, _MAX_PATH, m_szFile);
		if(*szTemp)
			sscanf(szTemp, "%d", &nValue);
		return nValue;
	}
	float GetFloatValue(const char *pszValue, float fDefault=0.0f)
	{
		float fValue = fDefault;
		char szTemp[_MAX_PATH];
		GetPrivateProfileString(m_szKey, pszValue, "", szTemp, _MAX_PATH, m_szFile);
		if(*szTemp)
			sscanf(szTemp, "%f", &fValue);
		return fValue;
	}
	CVector GetVectorValue(const char *pszValue, CVector vDefault=CVector(0.0f))
	{
		CVector vValue = vDefault;
		char szTemp[_MAX_PATH];
		GetPrivateProfileString(m_szKey, pszValue, "", szTemp, _MAX_PATH, m_szFile);
		if(*szTemp)
			sscanf(szTemp, "%f, %f, %f", &vValue.x, &vValue.y, &vValue.z);
		return vValue;
	}
	CVector4 GetVector4Value(const char *pszValue, CVector4 vDefault=CVector4(0.0f))
	{
		CVector4 vValue = vDefault;
		char szTemp[_MAX_PATH];
		GetPrivateProfileString(m_szKey, pszValue, "", szTemp, _MAX_PATH, m_szFile);
		if(*szTemp)
			sscanf(szTemp, "%f, %f, %f, %f", &vValue.x, &vValue.y, &vValue.z, &vValue.w);
		return vValue;
	}
	CColor GetColorValue(const char *pszValue, CColor cDefault=CColor(0, 0, 0, 0))
	{
		CColor cValue = cDefault;
		char szTemp[_MAX_PATH];
		GetPrivateProfileString(m_szKey, pszValue, "", szTemp, _MAX_PATH, m_szFile);
		if(*szTemp)
		{
			int r, g, b, a;
			sscanf(szTemp, "%d, %d, %d, %d", &r, &g, &b, &a);
			cValue = CColor((unsigned char)r, (unsigned char)g, (unsigned char)b, (unsigned char)a);
		}
		return cValue;
	}
};

#endif // __PlanetInfo_h__
