// PBuffer.h : header file
//

#ifndef __PBuffer_h__
#define __PBuffer_h__

#include "Texture.h"

#define MAX_PFORMATS 256
#define MAX_ATTRIBS  32
class CPBuffer
{
protected:
	int m_nWidth;
	int m_nHeight;
	int m_nFlags;

	HDC m_hDC;
	HGLRC m_hGLRC;
	HPBUFFERARB m_hBuffer;

public:
	enum {NoFlags = 0x00, DepthBuffer = 0x01, StencilBuffer = 0x02};

	CPBuffer()							{ m_hBuffer = NULL; }
	CPBuffer(int nWidth, int nHeight, int nFlags=(DepthBuffer|StencilBuffer))
	{
		m_hBuffer = NULL;
		Init(nWidth, nHeight);
	}
	~CPBuffer()							{ Cleanup(); }

	bool Init(int nWidth, int nHeight, int nFlags=(DepthBuffer|StencilBuffer));
	void Cleanup();
	void HandleModeSwitch();

	int GetWidth()						{ return m_nWidth; }
	int GetHeight()						{ return m_nHeight; }
	int GetFlags()						{ return m_nFlags; }
	HGLRC GetHGLRC()					{ return m_hGLRC; }
	HDC GetHDC()						{ return m_hDC; }
	void MakeCurrent()					{ if(m_hBuffer) wglMakeCurrent(m_hDC, m_hGLRC); }
};

#endif // __PBuffer_h__
