// PBuffer.cpp
//

#include "Master.h"
#include "GLUtil.h"


bool CPBuffer::Init(int nWidth, int nHeight, int nFlags)
{
	Cleanup();
	m_nFlags = nFlags;

	// Temporarily store the current device and rendering contexts
	HDC hDC = wglGetCurrentDC();
	HGLRC hGLRC = wglGetCurrentContext();

	// Set up floating point attributes for pbuffer
	int i;
	float fAttributes[2*MAX_ATTRIBS];
	for(i=0; i<2*MAX_ATTRIBS; i++)
		fAttributes[i] = 0;

	// Set up integer point attributes for pbuffer
	int iAttributes[2*MAX_ATTRIBS];
	for(i=0; i<2*MAX_ATTRIBS; i++)
		iAttributes[i] = 0;
	i=0;
	iAttributes[i++] = WGL_DRAW_TO_PBUFFER_ARB;
	iAttributes[i++] = true;
	iAttributes[i++] = WGL_PIXEL_TYPE_ARB;
	iAttributes[i++] = WGL_TYPE_RGBA_ARB;
	if(nFlags & DepthBuffer)
	{
		iAttributes[i++] = WGL_DEPTH_BITS_ARB;
		iAttributes[i++] = 1;
	}
	if(nFlags & StencilBuffer)
	{
		iAttributes[i++] = WGL_STENCIL_BITS_ARB;
		iAttributes[i++] = 1;
	}
	iAttributes[i++] = WGL_SUPPORT_OPENGL_ARB;
	iAttributes[i++] = true;

	int pFormat[MAX_PFORMATS];
	unsigned int nFormats;
	if(wglChoosePixelFormatARB(hDC, iAttributes, fAttributes, MAX_PFORMATS, pFormat, &nFormats) && nFormats > 0)
	{
		iAttributes[0] = 0;
		m_hBuffer = wglCreatePbufferARB(hDC, pFormat[0], nWidth, nHeight, iAttributes);
		if(!m_hBuffer)
		{
			TRACE("PBuffer initialization failed!");
			return false;
		}
		m_hDC = wglGetPbufferDCARB(m_hBuffer);
		m_hGLRC = wglCreateContext(m_hDC);
		wglQueryPbufferARB(m_hBuffer, WGL_PBUFFER_WIDTH_ARB, &m_nWidth);
		wglQueryPbufferARB(m_hBuffer, WGL_PBUFFER_HEIGHT_ARB, &m_nHeight);
		wglShareLists(hGLRC, m_hGLRC);
		return true;
	}
	return false;
}

void CPBuffer::Cleanup()
{
	if(m_hBuffer)
	{
		wglDeleteContext(m_hGLRC);
		wglReleasePbufferDCARB(m_hBuffer, m_hDC);
		wglDestroyPbufferARB(m_hBuffer);
		m_hBuffer = NULL;
	}
}

void CPBuffer::HandleModeSwitch()
{
	if(m_hBuffer)
	{
		int nLost = 0;
		wglQueryPbufferARB(m_hBuffer, WGL_PBUFFER_LOST_ARB, &nLost);
		if(nLost)
		{
			Cleanup();
			Init(m_nWidth, m_nHeight);
		}
	}
}
