// Math.h
//

#ifndef __Math_h__
#define __Math_h__

#define FP_BITS(fp) (*(DWORD *)&(fp))
#define FP_ABS_BITS(fp) (FP_BITS(fp)&0x7FFFFFFF)
#define FP_SIGN_BIT(fp) (FP_BITS(fp)&0x80000000)
#define FP_ONE_BITS 0x3F800000

extern float two;

class CMath
{
protected:
	static unsigned int fast_sqrt_table[0x10000];

public:
	static void InitStaticMembers();

	static float inv(float f)			{ return 1.0f/f;}
	static float sqrt(float f)			{ return sqrtf(f); }
	static float pow(float f, float e)	{ return powf(f, e); }
	static float exp(float f)			{ return expf(f); }
	static float cos(float f)			{ return cosf(f); }
	static float sin(float f)			{ return sinf(f); }
	static float acos(float f)			{ return acosf(f); }
	static float asin(float f)			{ return asinf(f); }
	static int toint(float f)			{ return (int)f; }

	static float fastexp(float f)
	{
		float r;
		int _i;
		r = -1.44269504f * (float)0x00800000 * (f);
		_i = (int)r + 0x3F800000;
		r = *(float *)&_i;
		return r;
	}

	static float fastinv(float f)
	{
		float r;
		__asm
		{
			mov     eax,0x7F000000
			sub     eax,dword ptr [f]
			mov     dword ptr [r],eax
			fld     dword ptr [f]
			fmul    dword ptr [r]
			fsubr   [two]
			fmul    dword ptr [r]
			fstp    dword ptr [r]
		};
		return r;
	}
	static float fastsqrt(float f)
	{
		DWORD bits = FP_BITS(f);
		if(bits == 0)
			return 0.0;                 // check for square root of 0
		FP_BITS(f) = fast_sqrt_table[(bits >> 8) & 0xFFFF] | ((((bits - 0x3F800000) >> 1) + 0x3F800000) & 0x7F800000);
		return f;
	}
	static int fasttoint(float f)
	{
		int n;
		int *p = &n;
		__asm
		{
			fld f
			mov edx,p
			FRNDINT
			fistp dword ptr [edx];
		}
		return n;
	}
};

#define FP_NORM_TO_BYTE(i,p)                                                 \
{                                                                            \
	float _n = (p) + 1.0f;                                                   \
	i = *(int *)&_n;                                                         \
	if (i >= 0x40000000)     i = 0xFF;                                       \
	else if (i <=0x3F800000) i = 0;                                          \
	else i = ((i) >> 15) & 0xFF;                                             \
}

inline unsigned long FP_NORM_TO_BYTE2(float p)                                                 
{                                                                            
	float fpTmp = p + 1.0f;                                                      
	return ((*(unsigned *)&fpTmp) >> 15) & 0xFF;  
}

inline unsigned long FP_NORM_TO_BYTE3(float p)     
{
	float ftmp = p + 12582912.0f;                                                      
	return ((*(unsigned long *)&ftmp) & 0xFF);
}


#endif // __Math_h__
