/*
	The Universe Development Kit
	Copyright (C) 2000  Sean O'Neil
	s_p_oneil@hotmail.com

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#pragma inline_depth( 255 )
#pragma inline_recursion( on )
#pragma auto_inline( on )

// Standard C includes
#define STRICT
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <winuser.h>
#include <pbt.h>
#include <mmsystem.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <float.h>

#include <GL\GL.h>
#include <GL\GLU.h>

// Defines and macros
#define _MAX_NAME			30
#define GAME_SECTION		"Game Engine"
#define DISPLAY_SECTION		"Display Engine"
#define SOUND_SECTION		"Sound Engine"
#define INPUT_SECTION		"Input Engine"

// Some physics defines
#define GRAVCONST		6.67259e-20f	// Gravitational constant of the universe (km3 / kg sec^2)
#define LIGHTSPEED		299792.458f		// Speed of light (km / sec)
#define SUN_RADIUS		695000.0f		// The radius of the sun (km)
#define SUN_STRENGTH	1370.0f			// The strength of the sun at 1 AU (Watts/m^2 or Joules/second/meter^2)
#define SUN_MASS		1.989e30f		// The mass of the sun (kg)
#define EARTH_RADIUS	6378.0f			// The radius of Earth (km)
#define EARTH_MASS		5.9736e24f		// The mass of Earth (kg)
#define EARTH_ORBIT		149600000.0f	// The Earth's distance from the sun (km), also equal to 1 AU
//#define PLUTO_ORBIT	5913520000.0f	// Pluto's distance from the sun (km)
#define MOON_RADIUS		1738.0f			// The radius of Earth's moon (km)
#define MOON_MASS		7.35e22f		// The mass of Earth's moon (kg)
#define MOON_ORBIT		384400.0f		// The moon's distance from Earth (km)

//             Distance  Radius    Mass
// Planet      (000 km)   (km)     (kg)
// ---------  ---------  ------  -------
// Mercury       57,910    2439  3.30e23
// Venus        108,200    6052  4.87e24
// Earth        149,600    6378  5.98e24
// Mars         227,940    3397  6.42e23
// Jupiter      778,330   71492  1.90e27
// Saturn     1,426,940   60268  5.69e26
// Uranus     2,870,990   25559  8.69e25
// Neptune    4,497,070   24764  1.02e26
// Pluto      5,913,520    1160  1.31e22

// My includes
#include "WndClass.h"
#include "ListTemplates.h"
#include "ListClasses.h"
