/*
	The Universe Development Kit
	Copyright (C) 2000  Sean O'Neil
	s_p_oneil@hotmail.com

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __GameEngine_h__
#define __GameEngine_h__

#include "Texture.h"
#include "Font.h"
#include "ROAMSphere.h"
#include "StarSystem.h"


/****************************************************************************
* Class: CGameEngine
*****************************************************************************
* This class implements the main engine. For now it just renders each frame. 
* It should eventually handle all logic for determining what happens each
* frame. This includes handling input, updating game objects, playing sounds,
* and rendering the frames.
****************************************************************************/
class CGameEngine
{
protected:
	CFont m_fFont;
	C3DObject m_3DCamera;
	CStarSystem m_starSystem;
	GLenum m_nPolygonMode;
	bool m_bTexture;
	bool m_bUpdate;
	bool m_bInfo;
	float m_fMaxError;

public:
	CGameEngine();
	~CGameEngine();
	void RenderFrame(int nMilliseconds);
	void Pause()	{}
	void Restore()	{}
	void HandleInput(float fSeconds);
	void TogglePolygonMode()
	{
		m_nPolygonMode = (m_nPolygonMode == GL_FILL) ? GL_LINE : GL_FILL;
		//glPolygonMode(GL_FRONT, m_nPolygonMode);
	}
	void ToggleTextures()		{ m_bTexture = !m_bTexture; }
	void ToggleInfo()			{ m_bInfo = !m_bInfo; }
	void ToggleUpdate()			{ m_bUpdate = !m_bUpdate; }
};

#endif // __GameEngine_h__
