// GLUtil.cpp
//

#include "Master.h"
#define GLH_EXT_SINGLE_FILE
#include "GLUtil.h"

/*
Allocated video memory:
vertex array range = 2.5 MB
pbuffers = 4 MB
*/


CVertexArray CVertex::Array;
CGLUtil g_glUtil;
CGLUtil *CGLUtil::m_pMain = &g_glUtil;

CGLUtil::CGLUtil()
{
	// Start by clearing out all the member variables
	m_bVertexArrayRanges = false;
	m_bCompiledVertexArrays = false;
	m_bPBuffers = false;
	m_bRegisterCombiners = false;
	m_nMaxTextureUnits = false;
	m_pArray = NULL;
	m_nFence = 0;
}

CGLUtil::~CGLUtil()
{
}

void CGLUtil::Init()
{
	// Start by storing the current HDC and HGLRC
	m_hDC = wglGetCurrentDC();
	m_hGLRC = wglGetCurrentContext();
	
	// Next initialize the OpenGL extensions we want to use
#ifndef _DEBUG	// Don't use the VAR when debugging because GPF's can force a reboot
	if(glh_init_extension("GL_NV_vertex_array_range") && glh_init_extension("GL_NV_fence"))
	{
		int nSize = GetVertexArraySize();
		m_pArray = (CVertex *)wglAllocateMemoryNV(nSize, 0, 0, 1.0f);
		if(!m_pArray)
			m_pArray = (CVertex *)wglAllocateMemoryNV(nSize, 0, 0, 0.5f);
		if(m_pArray)
		{
			glGenFencesNV(1, &m_nFence);
			m_bVertexArrayRanges = true;
		}
	}
#endif
	if(!m_bVertexArrayRanges)
		m_pArray = CVertex::Array.GetBuffer();

	if(glh_init_extension("GL_EXT_compiled_vertex_array"))
		m_bCompiledVertexArrays = true;

	if(glh_init_extension("GL_NV_register_combiners"))
		m_bRegisterCombiners = true;

	if(glh_init_extension("GL_ARB_multitexture"))
		glGetIntegerv(GL_MAX_TEXTURE_UNITS_ARB, &m_nMaxTextureUnits);

	if(glh_init_extension("WGL_ARB_pixel_format") && glh_init_extension("WGL_ARB_pbuffer"))
	{
		int nSize = 512;
		for(int i=0; i<8; i++)
		{
			m_PBuffer[i].Init(nSize, nSize);
			InitRenderContext(m_PBuffer[i].GetHDC(), m_PBuffer[i].GetHGLRC());
			nSize >>= 1;
		}
	}

	// Finally, initialize the default rendering context
	InitRenderContext(m_hDC, m_hGLRC);
}

void CGLUtil::Cleanup()
{
	if(m_bPBuffers)
	{
		for(int i=0; i<8; i++)
			m_PBuffer[i].Cleanup();
	}
	if(m_bVertexArrayRanges)
	{
		glDeleteFencesNV(1, &m_nFence);
		wglFreeMemoryNV(m_pArray);
	}
}

void CGLUtil::InitRenderContext(HDC hDC, HGLRC hGLRC)
{
	wglMakeCurrent(hDC, hGLRC);

	glEnable(GL_DEPTH_TEST);
	glDepthFunc(GL_LEQUAL);
	glEnable(GL_CULL_FACE);
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
	glLightModelfv(GL_LIGHT_MODEL_AMBIENT, CVector4(0.0f));

	if(m_bVertexArrayRanges)
	{
		glVertexArrayRangeNV(GetVertexArraySize(), m_pArray);
		glEnableClientState(GL_VERTEX_ARRAY_RANGE_NV);
	}
	EnableVertexArray();
	EnableNormalArray();

	wglMakeCurrent(m_hDC, m_hGLRC);
}

void CGLUtil::BeginVertexArray()
{
	if(m_bVertexArrayRanges)
	{
		glFinishFenceNV(m_nFence);
		for(unsigned short i=0; i<VERTEX_ARRAY_SIZE; i++)
		{
			if(CVertex::Array.GetFlags(i) & CVertexArray::Dirty)
			{
				m_pArray[i] = *CVertex::Array[i];
				CVertex::Array.ClearFlags(i, CVertexArray::Dirty);
			}
		}
	}
	if(m_bCompiledVertexArrays)
		glLockArraysEXT(0, VERTEX_ARRAY_SIZE);
}

void CGLUtil::EndVertexArray()
{
	if(m_bCompiledVertexArrays)
		glUnlockArraysEXT();
	if(m_bVertexArrayRanges)
		glSetFenceNV(m_nFence, GL_ALL_COMPLETED_NV);
}
